/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.devicegroups.NodeTypeAttr;
import com.intel.stl.api.subnet.DefaultDeviceGroup;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.admin.impl.devicegroups.DeviceNode;
import com.intel.stl.ui.admin.impl.devicegroups.DeviceNodesManager;
import com.intel.stl.ui.admin.impl.devicegroups.IResourceSelector;
import com.intel.stl.ui.admin.view.devicegroups.DevicesPanel;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.NameSorter;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DevicesSelector
implements IResourceSelector {
    private final DevicesPanel view;
    private ISubnetApi subnetApi;
    private boolean useGUID;
    private DefaultTreeModel treeModel;
    private TreeSelectionModel seletionModel;
    protected Comparator<FVResourceNode> guidComparator = new Comparator<FVResourceNode>(){

        @Override
        public int compare(FVResourceNode o1, FVResourceNode o2) {
            long guid1 = ((DeviceNode)o1).getGuid();
            long guid2 = ((DeviceNode)o2).getGuid();
            return Long.compare(guid1, guid2);
        }
    };
    protected Comparator<FVResourceNode> descComparator = new Comparator<FVResourceNode>(){

        @Override
        public int compare(FVResourceNode o1, FVResourceNode o2) {
            String desc1 = o1.getTitle();
            String desc2 = o2.getTitle();
            return NameSorter.instance().compare(desc1, desc2);
        }
    };

    public DevicesSelector(DevicesPanel view) {
        this.view = view;
        view.addOptionsListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesSelector.this.useGUID = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        view.setSelectionModel(this.getSelectionModel());
    }

    private TreeSelectionModel getSelectionModel() {
        if (this.seletionModel == null) {
            this.seletionModel = new DefaultTreeSelectionModel(){
                private static final long serialVersionUID = -1143512673362584183L;

                @Override
                public void setSelectionPaths(TreePath[] paths) {
                    TreePath[] validPaths = this.getValidPaths(paths);
                    super.setSelectionPaths(validPaths);
                }

                @Override
                public void addSelectionPaths(TreePath[] paths) {
                    TreePath[] validPaths = this.getValidPaths(paths);
                    super.addSelectionPaths(validPaths);
                }

                protected TreePath[] getValidPaths(TreePath[] paths) {
                    ArrayList<TreePath> pathList = new ArrayList<TreePath>();
                    for (TreePath path : paths) {
                        DeviceNode dn = (DeviceNode)path.getLastPathComponent();
                        if (dn.isSelected()) continue;
                        pathList.add(path);
                    }
                    return pathList.toArray(new TreePath[0]);
                }
            };
        }
        return this.seletionModel;
    }

    @Override
    public String getDescription() {
        return UILabels.STL81050_DG_DEVICES_DESC.getDescription();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
    }

    @Override
    public void clear() {
        if (this.treeModel != null) {
            DeviceNode root = (DeviceNode)this.treeModel.getRoot();
            root.clearSelection();
            this.view.repaint();
        }
    }

    @Override
    public String getName() {
        return STLConstants.K2134_DEVICES.getValue();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.subnetApi = context.getSubnetApi();
        SwingWorker<DefaultTreeModel, Void> worker = this.getInitWorker();
        worker.execute();
    }

    protected SwingWorker<DefaultTreeModel, Void> getInitWorker() {
        SwingWorker<DefaultTreeModel, Void> worker = new SwingWorker<DefaultTreeModel, Void>(){

            @Override
            protected DefaultTreeModel doInBackground() throws Exception {
                DeviceNode root = DevicesSelector.this.createTree();
                DefaultTreeModel model = new DefaultTreeModel(root);
                return model;
            }

            @Override
            protected void done() {
                try {
                    DevicesSelector.this.treeModel = (DefaultTreeModel)this.get();
                    DevicesSelector.this.view.setTreeModel(DevicesSelector.this.treeModel);
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    Util.showError(DevicesSelector.this.view, e);
                }
            }
        };
        return worker;
    }

    protected DeviceNode createTree() throws SubnetDataNotFoundException {
        DeviceNode root = new DeviceNode(DefaultDeviceGroup.ALL.getName(), TreeNodeType.ALL, 0, 0L);
        DeviceNode fi = new DeviceNode(NodeTypeAttr.FI.getName(), TreeNodeType.HCA_GROUP, 0, 0L);
        DeviceNode sw = new DeviceNode(NodeTypeAttr.SW.getName(), TreeNodeType.SWITCH_GROUP, 0, 0L);
        this.fillNodes(fi, sw);
        if (fi.getChildCount() > 0) {
            root.addChild(fi);
        }
        if (sw.getChildCount() > 0) {
            root.addChild(sw);
        }
        return root;
    }

    protected void fillNodes(DeviceNode fi, DeviceNode sw) throws SubnetDataNotFoundException {
        Map<Integer, List<DeviceNode>> portNodes = this.getPorts();
        List<NodeRecordBean> nodes = this.subnetApi.getNodes(false);
        HashMap<Long, DeviceNode> swSIMap = new HashMap<Long, DeviceNode>();
        HashMap<Long, DeviceNode> fiSIMap = new HashMap<Long, DeviceNode>();
        HashMap<Long, DeviceNode> fiNodeMap = new HashMap<Long, DeviceNode>();
        for (NodeRecordBean node : nodes) {
            DeviceNode siNode;
            long siGuid;
            NodeInfoBean ni;
            if (node.getNodeType() == NodeType.HFI) {
                long nodeGuid;
                DeviceNode fiNode;
                ni = node.getNodeInfo();
                siGuid = ni.getSysImageGUID();
                siNode = (DeviceNode)fiSIMap.get(siGuid);
                if (siNode == null) {
                    siNode = new DeviceNode(StringUtils.longHexString(siGuid), TreeNodeType.SYSTEM_IMAGE, node.getLid(), siGuid);
                    fi.addChild(siNode);
                    fiSIMap.put(siGuid, siNode);
                }
                if ((fiNode = (DeviceNode)fiNodeMap.get(nodeGuid = ni.getNodeGUID())) == null) {
                    fiNode = new DeviceNode(node.getNodeDesc(), TreeNodeType.HFI, node.getLid(), nodeGuid);
                    siNode.addChild(fiNode);
                    fiNodeMap.put(nodeGuid, fiNode);
                }
                DeviceNode fiPort = new DeviceNode(Integer.toString(ni.getLocalPortNum()), TreeNodeType.ACTIVE_PORT, ni.getLocalPortNum(), ni.getPortGUID());
                fiNode.addChild(fiPort);
                continue;
            }
            if (node.getNodeType() != NodeType.SWITCH) continue;
            ni = node.getNodeInfo();
            siGuid = ni.getSysImageGUID();
            siNode = (DeviceNode)swSIMap.get(siGuid);
            if (siNode == null) {
                siNode = new DeviceNode(StringUtils.longHexString(siGuid), TreeNodeType.SYSTEM_IMAGE, node.getLid(), siGuid);
                sw.addChild(siNode);
                swSIMap.put(siGuid, siNode);
            }
            DeviceNode swNode = new DeviceNode(node.getNodeDesc(), TreeNodeType.SWITCH, node.getLid(), ni.getNodeGUID());
            DeviceNode zeroPort = new DeviceNode("0", TreeNodeType.ACTIVE_PORT, 0, ni.getPortGUID());
            swNode.addChild(zeroPort);
            List<DeviceNode> ports = portNodes.get(node.getLid());
            if (ports != null) {
                for (DeviceNode port : ports) {
                    if (port.getId() == 0) continue;
                    swNode.addChild(port);
                }
            }
            siNode.addChild(swNode);
        }
        this.sortTree(fi, this.guidComparator);
        this.sortTree(sw, this.guidComparator);
    }

    protected Map<Integer, List<DeviceNode>> getPorts() throws SubnetDataNotFoundException {
        HashMap<Integer, List<DeviceNode>> res = new HashMap<Integer, List<DeviceNode>>();
        List<PortRecordBean> ports = this.subnetApi.getPorts();
        for (PortRecordBean port : ports) {
            int lid = port.getEndPortLID();
            ArrayList<DeviceNode> portNodes = (ArrayList<DeviceNode>)res.get(lid);
            if (portNodes == null) {
                portNodes = new ArrayList<DeviceNode>();
                res.put(lid, portNodes);
            }
            DeviceNode node = new DeviceNode(Integer.toString(port.getPortNum()), TreeNodeType.ACTIVE_PORT, port.getPortNum(), 0L);
            portNodes.add(node);
        }
        return res;
    }

    protected void sortTree(DeviceNode node, Comparator<FVResourceNode> comparator) {
        if (node.getChildCount() > 1) {
            Vector<FVResourceNode> children = node.getChildren();
            Collections.sort(children, comparator);
            for (FVResourceNode child : children) {
                this.sortTree((DeviceNode)child, comparator);
            }
        }
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return null;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return null;
    }

    @Override
    public List<IAttribute> getViewSelections() {
        TreePath[] paths = this.seletionModel.getSelectionPaths();
        DeviceNodesManager dnm = new DeviceNodesManager((DeviceNode)this.treeModel.getRoot());
        List<IAttribute> res = dnm.getAttributes(paths, this.useGUID);
        return res;
    }

    @Override
    public void setModelSelections(List<? extends IAttribute> attrs) {
        if (this.treeModel == null) {
            throw new RuntimeException("TreeModel is null");
        }
        DeviceNodesManager snMgr = new DeviceNodesManager((DeviceNode)this.treeModel.getRoot());
        for (IAttribute iAttribute : attrs) {
            DeviceNode[] nodes = snMgr.getNodes(iAttribute);
            if (nodes == null) continue;
            for (DeviceNode node : nodes) {
                node.setSelected(true);
            }
        }
        this.view.repaint();
    }

    @Override
    public void removeModelSelection(IAttribute attr) {
        if (this.treeModel == null) {
            throw new RuntimeException("TreeModel is null");
        }
        DeviceNodesManager snMgr = new DeviceNodesManager((DeviceNode)this.treeModel.getRoot());
        DeviceNode[] nodes = snMgr.getNodes(attr);
        if (nodes != null) {
            for (DeviceNode node : nodes) {
                node.setSelected(false);
            }
        }
        this.view.repaint();
    }

    @Override
    public void clearViewSelections() {
        this.seletionModel.clearSelection();
    }
}

