/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.logs;

import com.intel.stl.api.logs.ILogApi;
import com.intel.stl.api.logs.ILogStateListener;
import com.intel.stl.api.logs.LogConfigType;
import com.intel.stl.api.logs.LogErrorType;
import com.intel.stl.api.logs.LogInitBean;
import com.intel.stl.api.logs.LogMessageType;
import com.intel.stl.api.logs.LogResponse;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.logs.FilterTask;
import com.intel.stl.ui.admin.impl.logs.FilterType;
import com.intel.stl.ui.admin.impl.logs.GetLogTask;
import com.intel.stl.ui.admin.impl.logs.ILogController;
import com.intel.stl.ui.admin.impl.logs.ILogViewListener;
import com.intel.stl.ui.admin.impl.logs.ITextMenuListener;
import com.intel.stl.ui.admin.impl.logs.SearchKey;
import com.intel.stl.ui.admin.impl.logs.SearchState;
import com.intel.stl.ui.admin.impl.logs.SearchTask;
import com.intel.stl.ui.admin.impl.logs.TextEvent;
import com.intel.stl.ui.admin.view.ILoginListener;
import com.intel.stl.ui.admin.view.logs.LogViewType;
import com.intel.stl.ui.admin.view.logs.SMLogView;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.LogErrorTypeViz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMLogController
implements ILogController,
ILogViewListener,
ILogStateListener,
ILoginListener,
ITextMenuListener {
    private static final Logger log = LoggerFactory.getLogger(SMLogController.class);
    private final SMLogModel model;
    private final SMLogView view;
    private ILogApi logApi;
    public SubnetDescription subnet;
    public boolean endOfFile = true;
    public boolean initInProgress;
    public boolean reconfiguring;
    private IProgressObserver observer;
    private boolean firstPage;
    private boolean lastPage;
    private SearchTask searchTask;
    private FilterTask filterTask;
    private GetLogTask logTask;
    private boolean dirty;
    private DocumentListener setDirtyListener;
    private String subnetUserName;

    public SMLogController(SMLogModel model, SMLogView view) {
        this.model = model;
        this.view = view;
        this.view.setLoginListener(this);
        this.view.setLogController(this);
        this.view.setLogViewListener(this);
        this.view.setTextMenuListener(this);
    }

    public void setContext(Context context, IProgressObserver observer) {
        this.observer = observer;
        this.logApi = context.getLogApi();
        this.subnet = context.getSubnetDescription();
        this.logApi.setLogStateListener(this);
        if (observer != null) {
            observer.onFinish();
        }
    }

    public void onRefresh() {
        this.view.onEndOfPage();
        if (this.observer != null) {
            this.observer.onFinish();
        }
    }

    public HostInfo getHostInfo() {
        return this.subnet.getCurrentFE();
    }

    public SMLogView getView() {
        return this.view;
    }

    public void showView(String name) {
        this.view.setView(name);
    }

    public void showLoginView() {
        HostInfo hostInfo = this.getHostInfo();
        LoginBean credentials = new LoginBean(hostInfo.getSshUserName(), hostInfo.getHost(), String.valueOf(hostInfo.getSshPortNum()));
        this.model.setCredentials(credentials);
        this.model.setLogFilePath(this.logApi.getLogFilePath());
        this.view.clearLoginData();
        this.view.updateLoginView(this.model);
        this.showView(LogViewType.LOGIN.getValue());
    }

    public LoginBean getCredentials() {
        return this.view.getCredentials();
    }

    @Override
    public void onPrevious(long numLines) {
        this.checkLogTask();
        this.logTask = new GetLogTask(this.logApi, LogMessageType.PREVIOUS_PAGE, numLines);
        this.logTask.execute();
    }

    @Override
    public void onNext(long numLines) {
        this.checkLogTask();
        this.logTask = new GetLogTask(this.logApi, LogMessageType.NEXT_PAGE, numLines);
        this.logTask.execute();
    }

    @Override
    public void onConfigure() {
        this.logApi.stopLog();
        this.onCancelSearch(this.view.getLastSearchKey());
        this.view.resetSearchField();
        this.view.resetLogin();
        this.view.clearLoginData();
        this.view.updateLoginView(this.model);
        this.showView(LogViewType.LOGIN.getValue());
    }

    @Override
    public void onLastLines(long numLines) {
        this.checkLogTask();
        this.logTask = new GetLogTask(this.logApi, LogMessageType.LAST_LINES, numLines);
        this.logTask.execute();
    }

    public void onNumLines() {
        this.checkLogTask();
        this.logTask = new GetLogTask(this.logApi, LogMessageType.NUM_LINES, 0L);
        this.logTask.execute();
    }

    @Override
    public synchronized void onResponse(LogResponse response) {
        switch (response.getMsgType()) {
            case NUM_LINES: {
                try {
                    long totalNumLines = Long.parseLong(response.getEntries().get(0));
                    if (this.isLastPage() && this.model.getNumLines() < totalNumLines) {
                        this.setLastPage(false);
                    }
                    this.model.setNumLines(totalNumLines);
                    this.view.showTotalLines(this.model);
                    this.view.showLineRange(this.model.getStartLine(), this.model.getEndLine());
                    if (!this.initInProgress) break;
                    this.logApi.scheduleLastLines(this.view.getNumLinesRequested());
                    this.initInProgress = false;
                    this.view.resetLogin();
                }
                catch (NumberFormatException e) {
                    log.error(e.getCause().getMessage());
                }
                break;
            }
            case NEXT_PAGE: 
            case PREVIOUS_PAGE: {
                this.model.setLogMsg(response);
                this.model.setFilteredDoc(response.getEntries());
                this.view.updateLogView(this.model);
                this.view.restoreUserActions(this.firstPage, this.lastPage);
                this.view.setPageRunningVisible(false);
                break;
            }
            case LAST_LINES: {
                List<String> entries = response.getEntries();
                long totalNumLines = Long.parseLong(entries.get(0));
                this.model.setNumLines(totalNumLines);
                entries.remove(0);
                this.model.setLogMsg(response);
                long startLine = 0L;
                long endLine = 0L;
                if (totalNumLines < this.view.getNumLinesRequested()) {
                    startLine = 1L;
                    endLine = totalNumLines;
                } else {
                    startLine = totalNumLines - this.view.getNumLinesRequested() + 1L;
                    endLine = totalNumLines;
                }
                this.model.setStartLine(startLine);
                this.model.setEndLine(endLine);
                this.model.setFilteredDoc(response.getEntries());
                this.view.showProgress(false);
                this.view.showLogView();
                this.view.updateLogView(this.model);
                this.view.restoreUserActions(this.firstPage, this.lastPage);
                this.view.setRefreshRunningVisible(false);
                break;
            }
            case CHECK_FOR_FILE: {
                String fileName = response.getEntries().get(0);
                this.model.setLogFilePath(fileName);
                this.view.showFileName(fileName);
                break;
            }
            case UNKNOWN: {
                log.error(STLConstants.K2152_UNKNOWN_RESPONSE.getValue());
                break;
            }
        }
    }

    @Override
    public void credentialsReady() {
        if (!this.logApi.isRunning()) {
            LogConfigType configType = this.view.getConfigType();
            String logFilePath = this.view.getLogFilePath();
            LoginBean credentials = this.view.getCredentials();
            this.model.setCredentials(credentials);
            this.model.setLogFilePath(logFilePath);
            if (configType == LogConfigType.AUTO_CONFIG) {
                this.subnetUserName = this.view.getCredentials().getUserName();
            }
            this.subnet.getCurrentFE().setSshUserName(this.view.getCredentials().getUserName());
            String logHost = credentials.getHostName();
            LogInitBean logInitBean = new LogInitBean(this.subnet, configType, logHost, logFilePath, false, this.view.getCredentials().getUserName());
            this.initInProgress = true;
            this.logApi.startLog(logInitBean, this.view.getCredentials().getPassword());
        }
    }

    @Override
    public void onError(LogErrorType errorCode, Object ... data) {
        byte code = errorCode.getId();
        this.view.showProgress(false);
        this.view.setPageRunningVisible(false);
        this.view.setRefreshRunningVisible(false);
        this.view.restoreUserActions(this.firstPage, this.lastPage);
        this.view.clearLoginData();
        String message = LogErrorTypeViz.values()[code].getLabel().getDescription(data);
        if (this.view.isLoginView()) {
            this.view.showError(message);
        } else {
            this.view.showErrorDialog(message);
        }
        this.logApi.stopLog();
    }

    @Override
    public void onReady() {
        if (this.initInProgress) {
            this.logApi.scheduleLastLines(this.view.getNumLinesRequested());
            this.view.setNumLineIcon(true);
        }
    }

    @Override
    public void setLogMessage(LogResponse msg) {
        this.model.setLogMsg(msg);
    }

    @Override
    public void setFirstPage(boolean b) {
        this.firstPage = b;
        this.view.setPreviousEnabled(!b);
    }

    @Override
    public void setLastPage(boolean b) {
        this.lastPage = b;
        this.view.setNextEnabled(!b);
    }

    @Override
    public synchronized void onSearch(SearchState searchState) {
        String text = this.view.getDocument();
        List<FilterType> filters = this.view.getSelectedFilters();
        this.model.resetSearchResults();
        ArrayList<SearchKey> searchKeys = new ArrayList<SearchKey>();
        for (FilterType filter : filters) {
            searchKeys.add(new SearchKey(SearchState.FILTERED_SEARCH, filter.getName(), filter.getColor()));
        }
        String searchKey = this.view.getSearchKey();
        if (searchKey != null && !searchKey.isEmpty()) {
            searchKeys.add(new SearchKey(searchState, searchKey, UIConstants.INTEL_ORANGE));
        }
        this.view.enableSearch(false);
        boolean showErrors = searchState.equals((Object)SearchState.STANDARD_SEARCH);
        this.doSearch(text, showErrors, searchState, searchKeys);
    }

    public void doSearch(String text, boolean showErrors, SearchState searchState, SearchKey searchKey) {
        this.doSearch(text, showErrors, searchState, Collections.singletonList(searchKey));
    }

    public void doSearch(String text, boolean showErrors, SearchState searchState, List<SearchKey> searchKeys) {
        this.checkFilter();
        this.checkSearch();
        this.searchTask = new SearchTask(this.view, this.model, text, searchState, searchKeys);
        this.searchTask.execute();
    }

    @Override
    public void onCancelSearch(String searchKey) {
        this.checkSearch();
        this.model.resetSearchResults();
        this.view.showNumMatches(0L);
        this.view.unHighlightText();
        this.onSearch(SearchState.FILTERED_SEARCH);
    }

    protected synchronized void checkSearch() {
        try {
            if (this.searchTask != null && !this.searchTask.isDone()) {
                this.searchTask.cancel(true);
            }
        }
        catch (CancellationException e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void onSessionDown(String errorMessage) {
        this.view.showError(errorMessage);
        this.view.showLoginView();
        this.logApi.stopLog();
    }

    @Override
    public void onFilter() {
        this.checkSearch();
        this.checkFilter();
        this.filterTask = new FilterTask(this, this.model, this.view.getSelectedFilters());
        this.filterTask.execute();
    }

    protected synchronized void checkFilter() {
        if (this.filterTask != null && !this.filterTask.isDone()) {
            this.filterTask.cancel(true);
        }
    }

    protected synchronized void checkLogTask() {
        if (this.logTask != null && !this.logTask.isDone()) {
            this.logTask.cancel(true);
        }
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    @Override
    public void setStartLine(long lineNum) {
        this.model.setStartLine(lineNum);
    }

    @Override
    public void setEndLine(long lineNum) {
        this.model.setEndLine(lineNum);
    }

    @Override
    public void doAction(TextEvent e) {
        switch (e.getEventType()) {
            case COPY: 
            case PASTE: {
                break;
            }
            case HIGHLIGHT: {
                this.view.setSearchField(e.getText());
                this.onSearch(SearchState.MARKED_SEARCH);
                break;
            }
        }
    }

    @Override
    public void resetSearch() {
        this.model.resetSearchResults();
        this.view.resetSearchField();
        this.view.unHighlightText();
        this.view.showNumMatches(0L);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected void onDirty() {
        this.dirty = false;
        this.view.saveLastSearchKey();
    }

    @Override
    public void unHighlightSelection(String key, int start, int end) {
        this.view.unHighlightSelection(key, start, end);
    }

    @Override
    public int getSelectionStart() {
        return this.model.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.model.getSelectionEnd();
    }

    @Override
    public void setCurrentSelection(String key, int start, int end) {
        this.model.setSelection(key, start, end);
    }

    @Override
    public String getSelectedKey() {
        return this.model.getSelectedKey();
    }

    @Override
    public void cancelLogin() {
        this.view.clearLoginData();
        this.view.updateLoginView(this.model);
        this.logApi.stopLog();
    }

    @Override
    public DocumentListener getDocumentListener() {
        if (this.setDirtyListener == null) {
            this.setDirtyListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SMLogController.this.dirty = true;
                    SMLogController.this.onDirty();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SMLogController.this.dirty = true;
                    SMLogController.this.onCancelSearch(SMLogController.this.view.getLastSearchKey());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SMLogController.this.dirty = true;
                    SMLogController.this.onDirty();
                }
            };
        }
        return this.setDirtyListener;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void setCredentials(LoginBean credentials) {
        this.model.setCredentials(credentials);
    }

    @Override
    public void updateLoginView() {
        this.view.updateLoginView(this.model);
    }

    public boolean isInitInProgress() {
        return this.initInProgress;
    }

    @Override
    public void restoreAutoConfigView() {
        HostInfo hostInfo = this.subnet.getCurrentFE();
        hostInfo.setSshUserName(this.subnetUserName);
        LoginBean credentials = new LoginBean(hostInfo.getSshUserName(), hostInfo.getHost(), String.valueOf(hostInfo.getSshPortNum()));
        this.model.setCredentials(credentials);
        this.model.setLogFilePath(this.logApi.getDefaultLogFilePath());
        this.view.updateLoginView(this.model);
    }
}

