/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.virtualfabrics;

import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.InvalidEditException;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.AbstractEditorController;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.impl.virtualfabrics.VFValidationTask;
import com.intel.stl.ui.admin.impl.virtualfabrics.VirtualFabricsEditorController;
import com.intel.stl.ui.admin.view.AbstractConfView;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.virtualfabrics.VirtualFabricsEditorPanel;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class VirtualFabricsPageController
extends ConfPageController<VirtualFabric, VirtualFabricsEditorPanel> {
    private Set<String> reserved;

    public VirtualFabricsPageController(String name, String description, ImageIcon icon, final AbstractConfView<VirtualFabric, VirtualFabricsEditorPanel> view) {
        super(name, description, icon, view);
        view.getEditorPanel().setEnabledActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((VirtualFabricsEditorPanel)view.getEditorPanel()).updateItem(VirtualFabricsPageController.this.currentItem);
                    view.updateItems();
                }
                catch (InvalidEditException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getAdminVf();
    }

    @Override
    protected AbstractEditorController<VirtualFabric, VirtualFabricsEditorPanel> creatEditorController(VirtualFabricsEditorPanel editorPanel) {
        return new VirtualFabricsEditorController(editorPanel);
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        super.setContext(context, observer);
        this.edtCtr.setContext(context);
        this.reserved = this.mgtApi.getReservedVirtualFabrics();
    }

    @Override
    protected ArrayList<Item<VirtualFabric>> initData() throws Exception {
        this.edtCtr.initData();
        List<VirtualFabric> vfs = this.mgtApi.getVirtualFabrics();
        ArrayList<Item<VirtualFabric>> res = new ArrayList<Item<VirtualFabric>>();
        for (VirtualFabric vf : vfs) {
            boolean isEditable = this.isEditable(vf);
            Item<VirtualFabric> item = new Item<VirtualFabric>(res.size(), vf.getName(), vf, isEditable);
            item.setState(ChangeState.NONE);
            res.add(item);
        }
        return res;
    }

    private boolean isEditable(VirtualFabric vf) {
        String name = vf.getName();
        return !this.reserved.contains(name);
    }

    @Override
    protected VirtualFabric getCopy(VirtualFabric obj) {
        return obj.copy();
    }

    @Override
    protected VirtualFabric createObj() {
        return new VirtualFabric();
    }

    @Override
    protected void removeItemObject(String name) throws Exception {
        this.mgtApi.removeVirtualFabric(name);
    }

    @Override
    protected ValidationTask<VirtualFabric> getValidationTask(ValidationDialog dialog, Item<VirtualFabric> item) {
        VFValidationTask task = new VFValidationTask(dialog, this.valModel, this.orgItems, item);
        return task;
    }

    @Override
    protected void saveItemObject(String oldName, VirtualFabric obj) throws Exception {
        if (oldName != null) {
            this.mgtApi.updateVirtualFabric(oldName, obj);
        } else {
            this.mgtApi.addVirtualFabric(obj);
        }
    }
}

