/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.ui.admin.IItemEditorListener;
import com.intel.stl.ui.admin.InvalidEditException;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.SafeNameField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class AbstractEditorPanel<E>
extends JPanel {
    private static final long serialVersionUID = 6210030398358856720L;
    private JPanel namePanel;
    private JFormattedTextField nameField;
    private JButton helpBtn;
    private JPanel ctrPanel;
    private JButton saveBtn;
    private JButton resetBtn;
    private DocumentListener nameListener;
    private IItemEditorListener edtListener;

    public AbstractEditorPanel() {
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel panel = this.getNamePanel();
        this.add((Component)panel, "North");
        JComponent mainComp = this.getMainComponent();
        this.add((Component)mainComp, "Center");
        panel = this.getControlPanel();
        this.add((Component)panel, "South");
    }

    protected JPanel getNamePanel() {
        if (this.namePanel == null) {
            this.namePanel = new JPanel(new FlowLayout(3));
            JLabel nameLabel = ComponentFactory.getH3Label(STLConstants.K2111_NAME.getValue(), 1);
            this.namePanel.add(nameLabel);
            this.nameField = new SafeNameField(false);
            this.nameField.setColumns(32);
            this.namePanel.add(this.nameField);
            this.helpBtn = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
            this.helpBtn.setToolTipText(STLConstants.K0037_HELP.getValue());
            this.namePanel.add(this.helpBtn);
        }
        return this.namePanel;
    }

    public void enableHelp(boolean b) {
        if (this.helpBtn != null) {
            this.helpBtn.setEnabled(b);
        }
    }

    public JButton getHelpButton() {
        return this.helpBtn;
    }

    protected abstract JComponent getMainComponent();

    protected JPanel getControlPanel() {
        if (this.ctrPanel == null) {
            this.ctrPanel = new JPanel();
            this.ctrPanel.setOpaque(false);
            this.installButtons(this.ctrPanel);
        }
        return this.ctrPanel;
    }

    protected void installButtons(JPanel panel) {
        panel.setLayout(new FlowLayout(4));
        this.saveBtn = ComponentFactory.getIntelActionButton(STLConstants.K3010_SAVE.getValue());
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractEditorPanel.this.edtListener != null) {
                    AbstractEditorPanel.this.edtListener.onSave();
                }
            }
        });
        panel.add(this.saveBtn);
        this.resetBtn = ComponentFactory.getIntelActionButton(STLConstants.K1006_RESET.getValue());
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractEditorPanel.this.edtListener != null) {
                    AbstractEditorPanel.this.edtListener.onReset();
                }
            }
        });
        panel.add(this.resetBtn);
    }

    protected DocumentListener getNameListener() {
        if (this.nameListener == null) {
            this.nameListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Document doc = e.getDocument();
                    try {
                        AbstractEditorPanel.this.updateName(doc.getText(0, doc.getLength()));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Document doc = e.getDocument();
                    try {
                        AbstractEditorPanel.this.updateName(doc.getText(0, doc.getLength()));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        return this.nameListener;
    }

    protected void updateName(String text) {
        if (this.edtListener != null) {
            this.edtListener.nameChanged(text);
        }
    }

    public void setEditorListener(IItemEditorListener listener) {
        this.edtListener = listener;
    }

    public void setItem(final Item<E> item, final Item<E>[] items) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                AbstractEditorPanel.this.nameField.getDocument().removeDocumentListener(AbstractEditorPanel.this.getNameListener());
                AbstractEditorPanel.this.setItemName(item.getName());
                String[] appNames = new String[items.length];
                for (int i = 0; i < appNames.length; ++i) {
                    appNames[i] = items[i].getName();
                }
                AbstractEditorPanel.this.showItemObject(item.getObj(), appNames, item.isEditable());
                AbstractEditorPanel.this.nameField.setEnabled(item.isEditable());
                AbstractEditorPanel.this.saveBtn.setEnabled(item.isEditable());
                AbstractEditorPanel.this.resetBtn.setEnabled(item.isEditable());
                AbstractEditorPanel.this.nameField.requestFocusInWindow();
                AbstractEditorPanel.this.nameField.getDocument().addDocumentListener(AbstractEditorPanel.this.getNameListener());
            }
        });
    }

    public void selectItemName() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractEditorPanel.this.nameField.selectAll();
            }
        });
    }

    protected void setItemName(String name) {
        this.nameField.setText(name);
    }

    protected abstract void showItemObject(E var1, String[] var2, boolean var3);

    public abstract void itemNameChanged(String var1, String var2);

    public void clear() {
        this.nameField.getDocument().removeDocumentListener(this.getNameListener());
        this.setItemName(null);
        this.nameField.setEnabled(false);
        this.saveBtn.setEnabled(false);
        this.resetBtn.setEnabled(false);
    }

    protected String getCurrentName() {
        return this.nameField.getText();
    }

    public void updateItem(Item<E> item) throws InvalidEditException {
        if (!this.isEditValid()) {
            throw new InvalidEditException(UILabels.STL81053_INVALID_EDIT.getDescription());
        }
        item.setName(this.getCurrentName());
        this.updateItemObject(item.getObj());
    }

    protected abstract void updateItemObject(E var1);

    protected boolean isEditValid() {
        return this.nameField.isEditValid();
    }
}

