/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.logs;

import com.intel.stl.ui.admin.impl.logs.ITextMenuListener;
import com.intel.stl.ui.admin.impl.logs.SearchKey;
import com.intel.stl.ui.admin.impl.logs.SearchPositionBean;
import com.intel.stl.ui.admin.impl.logs.SearchState;
import com.intel.stl.ui.admin.impl.logs.TextEventType;
import com.intel.stl.ui.admin.view.logs.AbstractLogView;
import com.intel.stl.ui.admin.view.logs.TextMenuPanel;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class SMLogView
extends AbstractLogView {
    private static final long serialVersionUID = -2959984172557178645L;
    private JTextArea txtAreaMain;
    private TextMenuPanel pnlMainMenu;

    public void setTextMenuListener(ITextMenuListener listener) {
        if (this.pnlMainMenu != null) {
            this.pnlMainMenu.setTextMenuListener(listener);
        }
        this.pnlSearchMenu.setTextMenuListener(listener);
    }

    @Override
    protected Component getMainComponent() {
        this.txtAreaMain = new JTextArea();
        this.txtAreaMain.setBackground(UIConstants.INTEL_WHITE);
        this.txtAreaMain.setFont(UIConstants.H4_FONT);
        this.txtAreaMain.setLineWrap(true);
        this.txtAreaMain.setWrapStyleWord(true);
        this.txtAreaMain.setEditable(false);
        this.txtAreaMain.getDocument().putProperty("__EndOfLine__", "\n");
        Highlighter h = this.txtAreaMain.getHighlighter();
        try {
            h.addHighlight(0, 0, new DefaultHighlighter.DefaultHighlightPainter(UIConstants.INTEL_BLUE));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ArrayList<TextEventType> eventTypes = new ArrayList<TextEventType>(Arrays.asList(TextEventType.COPY, TextEventType.HIGHLIGHT));
        this.pnlMainMenu = new TextMenuPanel(eventTypes);
        this.txtAreaMain.addMouseListener(this.pnlMainMenu);
        JScrollPane scrpnMain = new JScrollPane(this.txtAreaMain);
        scrpnMain.setVerticalScrollBarPolicy(20);
        scrpnMain.setHorizontalScrollBarPolicy(30);
        return scrpnMain;
    }

    @Override
    JTextComponent getTextContent() {
        return this.txtAreaMain;
    }

    @Override
    public void showLogEntry(final List<String> entries) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                SMLogView.this.txtAreaMain.setText(null);
                if (entries == null) {
                    return;
                }
                int numEntries = entries.size();
                for (int i = 0; i < numEntries; ++i) {
                    SMLogView.this.txtAreaMain.append((String)entries.get(i));
                    if (i >= numEntries - 1) continue;
                    SMLogView.this.txtAreaMain.append("\n");
                }
                int endPosition = SMLogView.this.txtAreaMain.getDocument().getLength();
                SMLogView.this.txtAreaMain.setCaretPosition(endPosition);
            }
        });
    }

    public void setEsmView() {
        this.txtAreaMain.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.txtAreaMain.setBackground(UIConstants.INTEL_LIGHT_GRAY);
        this.txtAreaMain.setFont(UIConstants.H2_FONT.deriveFont(1));
    }

    public void unHighlightText() {
        this.txtAreaMain.getHighlighter().removeAllHighlights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unHighlightSelection(String key, int start, int end) {
        SearchPositionBean selectedBean = new SearchPositionBean(key, start, end, new DefaultHighlighter.DefaultHighlightPainter(UIConstants.INTEL_ORANGE));
        try {
            this.txtAreaMain.getHighlighter().addHighlight(selectedBean.getStartOffset(), selectedBean.getEndOffset(), selectedBean.getPainter());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            this.logViewListener.setCurrentSelection("", 0, 0);
        }
    }

    @Override
    public void highlightText(List<SearchKey> searchKeys, List<SearchPositionBean> searchResults, SearchState searchState) {
        boolean showErrors;
        boolean bl = showErrors = searchState.equals((Object)SearchState.MARKED_SEARCH) || searchState.equals((Object)SearchState.STANDARD_SEARCH);
        if (showErrors) {
            boolean found = false;
            String searchToken = null;
            Iterator<SearchKey> it = searchKeys.iterator();
            while (!found && it.hasNext()) {
                SearchKey key = it.next();
                if (!key.getState().equals((Object)SearchState.MARKED_SEARCH) && !key.getState().equals((Object)SearchState.STANDARD_SEARCH)) continue;
                searchToken = key.getText();
                found = true;
            }
            if (found) {
                found = false;
                Iterator<SearchPositionBean> itr = searchResults.iterator();
                while (!found && itr.hasNext()) {
                    SearchPositionBean result = itr.next();
                    found = searchToken.equals(result.getKey());
                }
                if (!found) {
                    Util.showErrorMessage(this, UILabels.STL50206_SEARCH_TEXT_NOT_FOUND.getDescription(searchToken));
                    return;
                }
            }
        }
        this.unHighlightText();
        Highlighter highlighter = this.txtAreaMain.getHighlighter();
        for (SearchPositionBean position : searchResults) {
            try {
                highlighter.addHighlight(position.getStartOffset(), position.getEndOffset(), position.getPainter());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void moveToText(int start, int end) {
        this.txtAreaMain.setCaretPosition(start);
        this.txtAreaMain.moveCaretPosition(start);
    }
}

