/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.ui.alert.INotifyRule;
import com.intel.stl.ui.alert.MailNotifyRule;
import com.intel.stl.ui.alert.NoticeNotifier;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.main.Context;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotifier
extends NoticeNotifier {
    private static Logger log = LoggerFactory.getLogger(MailNotifier.class);
    private static boolean DEBUG = true;
    private final List<String> recipients = new ArrayList<String>();
    private final String subnetName;

    public MailNotifier(Context context, List<INotifyRule> rules, List<String> recipients) {
        super(context, rules);
        log.debug("MailNotifier: constructor called.");
        this.subnetName = context.getSubnetDescription().getName();
        this.setRecipients(recipients);
    }

    public synchronized void setRecipients(List<String> recipients) {
        if (recipients != null) {
            this.recipients.clear();
            this.recipients.addAll(recipients);
        }
    }

    public synchronized List<String> getRecipients() {
        return this.recipients;
    }

    public synchronized void setEventRules(List<EventRule> eventRules) {
        ArrayList<INotifyRule> notifyRules = new ArrayList<INotifyRule>();
        if (eventRules != null) {
            block0: for (EventRule eventRule : eventRules) {
                List<EventRuleAction> actions = eventRule.getEventActions();
                for (EventRuleAction action : actions) {
                    if (!action.equals((Object)EventRuleAction.SEND_EMAIL)) continue;
                    notifyRules.add(new MailNotifyRule(eventRule));
                    continue block0;
                }
            }
            this.setRules(notifyRules);
        }
    }

    @Override
    protected synchronized void notify(List<EventDescription> toSend) {
        log.debug("MailNotifier: notify called.");
        if (toSend == null || toSend.isEmpty()) {
            return;
        }
        for (EventDescription event : toSend) {
            String subject = this.createMessageSubject(event);
            String body = this.createMessageBody(event);
            this.context.getConfigurationApi().submitMessage(subject, body, this.recipients);
        }
    }

    protected String createMessageSubject(EventDescription event) {
        String subject = UILabels.STL92000_EMAIL_SUBJECT.getDescription(new Object[]{this.context.getSubnetDescription().getName(), event.getSeverity()});
        return subject;
    }

    protected String createMessageBody(EventDescription event) {
        return event.toString();
    }
}

