/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.DistributionPiePanel;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.ImageIcon;
import org.jfree.data.general.DefaultPieDataset;

public class DistributionPieController {
    private DefaultPieDataset dataset;
    private String[] items;
    private int[] values;
    private int sum;
    private DistributionPiePanel distributionPie;

    public DistributionPieController(DistributionPiePanel distributionPie, String[] items, int[] values, Color[] colors, int lableColumns) {
        this.distributionPie = distributionPie;
        this.items = items;
        this.updateValues(values);
        String[] itemLabels = new String[items.length];
        ImageIcon[] icons = new ImageIcon[items.length];
        for (int i = 0; i < items.length; ++i) {
            itemLabels[i] = this.getItemLegend(i);
            icons[i] = Util.generateImageIcon(colors[i], 10, new Insets(1, 1, 1, 1));
        }
        distributionPie.setDataset(this.dataset, colors);
        distributionPie.setLabels(itemLabels, icons, lableColumns);
    }

    public DistributionPiePanel getDistributionPie() {
        return this.distributionPie;
    }

    protected void check(String[] names, Color[] colors) {
        if (names == null) {
            throw new IllegalArgumentException("No names for segments");
        }
        if (colors != null && colors.length != names.length) {
            throw new IllegalArgumentException("Invalid argument. Expected " + colors.length + " colors, got " + this.values.length + " colors.");
        }
    }

    protected void check(int[] values, String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("No names for segments");
        }
        if (values != null && values.length != names.length) {
            throw new IllegalArgumentException("Invalid argument. Expected " + names.length + " values, got " + values.length + " values.");
        }
    }

    protected String getItemLegend(int i) {
        if (this.values == null) {
            return " ";
        }
        double perentage = (double)this.values[i] / (double)this.sum;
        return UIConstants.PERCENTAGE.format(perentage) + " " + this.items[i];
    }

    public void setDistribution(int[] values) {
        this.updateValues(values);
        final String[] itemLabels = new String[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            itemLabels[i] = this.getItemLegend(i);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                DistributionPieController.this.distributionPie.update(itemLabels);
            }
        });
    }

    protected void updateValues(int[] values) {
        this.check(values, this.items);
        this.values = values;
        this.sum = 0;
        if (this.dataset == null) {
            this.dataset = new DefaultPieDataset();
        }
        if (values == null) {
            for (int i = 0; i < this.items.length; ++i) {
                this.dataset.setValue((Comparable)((Object)this.items[i]), 0.0);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.dataset.setValue((Comparable)((Object)this.items[i]), (double)values[i]);
                this.sum += values[i];
            }
        }
    }
}

