/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class DocumentDirtyListener
implements DocumentListener {
    public static final String ORIGINAL_TEXT = "orig";
    public static final String CURRENT_TEXT = "text";

    @Override
    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        String originalText = (String)doc.getProperty(ORIGINAL_TEXT);
        if (originalText == null) {
            originalText = this.getTextFromDocument(doc);
            doc.putProperty(ORIGINAL_TEXT, originalText);
            if (originalText != null && originalText.length() > 0) {
                this.setDirty(e);
            }
        }
        String newText = this.getTextFromDocument(doc);
        doc.putProperty(CURRENT_TEXT, newText);
        if (!newText.equals(originalText)) {
            this.setDirty(e);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        String originalText = (String)doc.getProperty(ORIGINAL_TEXT);
        String newText = (String)doc.getProperty(CURRENT_TEXT);
        if (newText != null && e.getOffset() == 0 && e.getLength() == newText.length()) {
            doc.putProperty(ORIGINAL_TEXT, newText);
        } else {
            newText = this.getTextFromDocument(doc);
            doc.putProperty(CURRENT_TEXT, newText);
            if (!newText.equals(originalText)) {
                this.setDirty(e);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setDirty(e);
    }

    public abstract void setDirty(DocumentEvent var1);

    private String getTextFromDocument(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }
}

