/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import java.util.Comparator;

public class NameSorter
implements Comparator<String> {
    private static final NameSorter instance = new NameSorter();

    private NameSorter() {
    }

    public static NameSorter instance() {
        return instance;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null) {
            if (o2 != null) {
                return -1;
            }
            return 0;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.isEmpty()) {
            if (!o2.isEmpty()) {
                return -1;
            }
            return 0;
        }
        if (o2.isEmpty()) {
            return 1;
        }
        return new MixedString(o1).compareTo(new MixedString(o2));
    }

    private static class MixedString
    implements Comparable<MixedString> {
        private Long prefix;
        private final String mainString;
        private Long suffix;

        public MixedString(String str) {
            int len;
            int prePos = 0;
            int sufPos = len = str.length();
            while (prePos < len && Character.isDigit(str.charAt(prePos++))) {
            }
            if (--prePos > 0) {
                this.prefix = Long.valueOf(str.substring(0, prePos));
            }
            if (prePos < len - 1) {
                while (Character.isDigit(str.charAt(--sufPos))) {
                }
                if (++sufPos < len) {
                    this.suffix = Long.valueOf(str.substring(sufPos, len));
                }
            }
            this.mainString = prePos < sufPos - 1 ? str.substring(prePos, sufPos) : null;
        }

        @Override
        public int compareTo(MixedString o) {
            int res;
            if (this.mainString == null) {
                if (o.mainString != null) {
                    return -1;
                }
            } else if (o.mainString == null) {
                return 1;
            }
            if ((res = this.compare(this.prefix, o.prefix)) != 0) {
                return res;
            }
            if (this.mainString != null && (res = this.mainString.compareTo(o.mainString)) != 0) {
                return res;
            }
            return this.compare(this.suffix, o.suffix);
        }

        private int compare(Long v1, Long v2) {
            if (v1 == null) {
                if (v2 != null) {
                    return -1;
                }
                return 0;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }
    }
}

