/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.PinArgument;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class DecoratedPinCardView
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -6977548379083364984L;
    private static final boolean DEBUG = false;
    private static final String MAIN = "Main";
    private static final String INFO = "Info";
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JButton infoBtn;
    private JButton upBtn;
    private JButton downBtn;
    private JButton closeBtn;
    private JPanel sourcePanel;
    private JPanel mainPanel;
    private JPanel infoPanel;
    private final PinDescription pinDesc;
    private Resize resize = Resize.NONE;
    private int startHeight;
    private int startResizeY;
    private boolean isResizing = false;
    private final Border normalBorder;
    private final Border resizeBorder;

    public DecoratedPinCardView(Component comp, String title, PinDescription pin) {
        this.pinDesc = pin;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.normalBorder = BorderFactory.createMatteBorder(3, 1, 2, 1, UIConstants.INTEL_BORDER_GRAY);
        this.resizeBorder = BorderFactory.createLineBorder(UIConstants.INTEL_BLUE, 2);
        this.setBorder(this.normalBorder);
        JPanel titlePanel = this.getTitltPanel();
        this.add((Component)titlePanel, "North");
        this.mainPanel = new JPanel(new CardLayout());
        this.mainPanel.setOpaque(false);
        Map<String, String> sourceDesc = this.pinDesc.getArgument().getSourceDescription();
        if (sourceDesc == null) {
            this.mainPanel.add(comp, MAIN);
        } else {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            JPanel sourcePanel = this.getSourcePanel(sourceDesc);
            panel.add((Component)sourcePanel, "North");
            panel.add(comp);
            this.mainPanel.add((Component)panel, MAIN);
        }
        JPanel infoPanel = this.getInfoPanel();
        JScrollPane pane = new JScrollPane(infoPanel);
        pane.getViewport().setBackground(UIConstants.INTEL_WHITE);
        this.mainPanel.add((Component)pane, INFO);
        this.add((Component)this.mainPanel, "Center");
        this.setTitle(title);
        this.setDescription(pin.getDescription());
        Dimension compDim = comp.getPreferredSize();
        Dimension prefDim = new Dimension(compDim.width, compDim.height + titlePanel.getPreferredSize().height);
        this.setPreferredSize(prefDim);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected JPanel getTitltPanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel(new BorderLayout());
            this.titlePanel.setOpaque(false);
            this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE));
            this.titleLabel = ComponentFactory.getH4Label("", 0);
            this.titlePanel.add((Component)this.titleLabel, "Center");
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            toolbar.setBackground(UIConstants.INTEL_WHITE);
            this.installButtons(toolbar);
            this.titlePanel.add((Component)toolbar, "East");
        }
        return this.titlePanel;
    }

    protected void installButtons(JToolBar toolbar) {
        if (!this.pinDesc.getArgument().isEmpty()) {
            this.infoBtn = ComponentFactory.getImageButton(UIImages.INFORMATION_ICON.getImageIcon());
            this.infoBtn.setSelected(false);
            this.infoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DecoratedPinCardView.this.showInfo();
                }
            });
            toolbar.add(this.infoBtn);
        }
        this.upBtn = new JButton(UIImages.GO_UP.getImageIcon());
        this.upBtn.setOpaque(false);
        this.upBtn.setToolTipText(STLConstants.K4001_GO_UP.getValue());
        this.upBtn.setEnabled(false);
        toolbar.add(this.upBtn);
        this.downBtn = new JButton(UIImages.GO_DOWN.getImageIcon());
        this.downBtn.setOpaque(false);
        this.downBtn.setToolTipText(STLConstants.K4002_GO_DOWN.getValue());
        this.downBtn.setEnabled(false);
        toolbar.add(this.downBtn);
        this.closeBtn = new JButton(UIImages.CLOSE_RED.getImageIcon());
        this.closeBtn.setOpaque(false);
        this.closeBtn.setToolTipText(STLConstants.K4003_UNPIN.getValue());
        this.closeBtn.setRolloverIcon(UIImages.CLOSE_RED.getImageIcon());
        toolbar.add(this.closeBtn);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setTitle(String title, Icon icon) {
        this.titleLabel.setText(title);
        this.titleLabel.setIcon(icon);
    }

    public void setDescription(String description) {
        this.titleLabel.setToolTipText(description);
    }

    protected JPanel getSourcePanel(Map<String, String> sourceDesc) {
        if (this.sourcePanel == null) {
            this.sourcePanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.sourcePanel, 1);
            this.sourcePanel.setLayout(layout);
            this.sourcePanel.setOpaque(false);
            this.sourcePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 5, 0, 5), BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY)));
            for (String key : sourceDesc.keySet()) {
                JPanel panel = new JPanel(new FlowLayout(1, 5, 2));
                JLabel label = ComponentFactory.getH6Label(key, 1);
                label.setHorizontalAlignment(4);
                panel.add(label);
                label = ComponentFactory.getH6Label(sourceDesc.get(key), 0);
                panel.add(label);
                this.sourcePanel.add(panel);
            }
        }
        return this.sourcePanel;
    }

    public void enableUpButton(boolean b) {
        this.upBtn.setEnabled(b);
    }

    public void enableDownButton(boolean b) {
        this.downBtn.setEnabled(b);
    }

    public void setUpAction(ActionListener listener) {
        this.upBtn.addActionListener(listener);
    }

    public void setDownAction(ActionListener listener) {
        this.downBtn.addActionListener(listener);
    }

    public void setCloseAction(ActionListener listener) {
        this.closeBtn.addActionListener(listener);
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new CardLayout());
            this.mainPanel.setOpaque(false);
        }
        return this.mainPanel;
    }

    protected JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel(new GridBagLayout());
            this.infoPanel.setOpaque(false);
            PinArgument props = this.pinDesc.getArgument();
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(2, 2, 2, 2);
            if (props.isEmpty()) {
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.fill = 1;
                JLabel label = ComponentFactory.getH4Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 1);
                this.infoPanel.add((Component)label, gc);
            } else {
                for (String name : props.stringPropertyNames()) {
                    gc.gridwidth = 1;
                    JLabel label = ComponentFactory.getH4Label(name, 1);
                    label.setHorizontalAlignment(4);
                    this.infoPanel.add((Component)label, gc);
                    gc.gridwidth = 0;
                    label = ComponentFactory.getH4Label(props.getProperty(name), 0);
                    label.setHorizontalAlignment(10);
                    this.infoPanel.add((Component)label, gc);
                }
            }
            gc.weighty = 1.0;
            gc.fill = 1;
            this.infoPanel.add(Box.createGlue(), gc);
        }
        return this.infoPanel;
    }

    protected void showInfo() {
        CardLayout layout = (CardLayout)this.mainPanel.getLayout();
        if (this.infoBtn.isSelected()) {
            layout.show(this.mainPanel, MAIN);
            this.infoBtn.setSelected(false);
        } else {
            layout.show(this.mainPanel, INFO);
            this.infoBtn.setSelected(true);
        }
        this.repaint();
    }

    public int getComponentHeight() {
        return this.getSize().height - this.titlePanel.getSize().height;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.resize == Resize.READY) {
            this.resize = Resize.START;
            this.startResizeY = e.getYOnScreen();
            this.startHeight = this.getPreferredSize().height;
            this.setBorder(this.resizeBorder);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.resize == Resize.START) {
            int newHeight = e.getYOnScreen() - this.startResizeY + this.startHeight;
            this.adjustHeight(newHeight);
            this.setBorder(this.normalBorder);
        }
        this.resize = Resize.NONE;
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.resize != Resize.START) {
            this.resize = Resize.NONE;
            this.setCursor(Cursor.getDefaultCursor());
            if (this.getBorder() != this.normalBorder) {
                this.setBorder(this.normalBorder);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.resize != Resize.START) {
            return;
        }
        if (!this.isResizing) {
            this.isResizing = true;
            int newHeight = e.getYOnScreen() - this.startResizeY + this.startHeight;
            this.adjustHeight(newHeight);
            this.isResizing = false;
        }
    }

    protected void adjustHeight(int newHeight) {
        Dimension dim = this.getPreferredSize();
        dim.height = newHeight;
        this.setPreferredSize(dim);
        this.getParent().revalidate();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.resize != Resize.NONE) {
            return;
        }
        int delta = e.getPoint().y - this.getHeight();
        if (delta > -10 && delta < 10) {
            this.setCursor(Cursor.getPredefinedCursor(9));
            this.resize = Resize.READY;
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static enum Resize {
        NONE,
        READY,
        START,
        DRAG;

    }
}

