/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.JXList;

public class ExJXList<E>
extends JXList {
    private static final long serialVersionUID = 7774901357006599064L;
    private final List<E> disabledItems = new ArrayList();
    private final Set<Integer> disabledItemIds = new HashSet<Integer>();
    private Color disabledColor;
    private ListModel<?> dataModel;

    public ExJXList(E[] items) {
        super((Object[])items);
        super.setCellRenderer((ListCellRenderer)new DisabledItemsRenderer());
        this.dataModel = super.getModel();
        this.dataModel.addListDataListener(new ExListDataListener());
    }

    public void setDisabledColor(Color disabledColor) {
        this.disabledColor = disabledColor;
    }

    public void remove(int anIndex) {
        Object toRemove = this.dataModel.getElementAt(anIndex);
        this.disabledItems.remove(toRemove);
        this.chacheDisabledIndices();
        this.adjustSelection();
    }

    public void setDisabledItem(E ... items) {
        this.disabledItems.clear();
        this.disabledItemIds.clear();
        if (items == null || items.length == 0) {
            return;
        }
        this.disabledItems.addAll(Arrays.asList(items));
        this.chacheDisabledIndices();
        this.adjustSelection();
    }

    protected void chacheDisabledIndices() {
        this.disabledItemIds.clear();
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            Object element = this.dataModel.getElementAt(i);
            for (E item : this.disabledItems) {
                if (element == null || !element.equals(item)) continue;
                this.disabledItemIds.add(i);
            }
        }
    }

    protected void adjustSelection() {
        Object selected = super.getSelectedValue();
        if (selected == null) {
            return;
        }
        block0: for (E item : this.disabledItems) {
            if (!selected.equals(item)) continue;
            boolean foundDisabledItem = false;
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Object element = this.dataModel.getElementAt(i);
                if (!foundDisabledItem) {
                    foundDisabledItem = element != null && element.equals(item);
                    continue;
                }
                if (this.disabledItemIds.contains(i)) continue;
                super.setSelectedValue(element, true);
                continue block0;
            }
        }
    }

    public void setSelectedIndex(int index) {
        if (!this.disabledItemIds.contains(index)) {
            super.setSelectedIndex(index);
        }
    }

    public ExJXList(Vector<E> items) {
        super(items);
        super.setCellRenderer((ListCellRenderer)new DisabledItemsRenderer());
    }

    private class ExListDataListener
    implements ListDataListener {
        private ExListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int high = e.getIndex1();
            for (int low = e.getIndex0(); low <= high; ++low) {
                ExJXList.this.remove(low);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    }

    private class DisabledItemsRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5395462996710992524L;

        private DisabledItemsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (ExJXList.this.disabledItemIds.contains(index)) {
                if (ExJXList.this.disabledColor != null) {
                    label.setForeground(ExJXList.this.disabledColor);
                } else {
                    label.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            }
            return label;
        }
    }
}

