/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.IHelp;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.help.BadIDException;
import javax.help.JHelpContentViewer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpView
extends JPanel {
    private static final long serialVersionUID = 6892075486378808599L;
    private static final Logger log = LoggerFactory.getLogger(HelpView.class);
    private final String title;
    private List<String> topicIdList;
    private final JHelpContentViewer topicPanel;
    private JComboBox cboxTopic;
    private final IHelp helpController;

    public HelpView(String title, List<String> topicIdList, JHelpContentViewer topicPanel, IHelp helpController) {
        this.title = title;
        this.topicIdList = topicIdList;
        this.topicPanel = topicPanel;
        this.helpController = helpController;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(1, 5, 2, 5);
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        JLabel lblTitle = new JLabel(this.title);
        lblTitle.setFont(new Font("Segoe UI", 0, 16));
        lblTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.ORANGE));
        lblTitle.setHorizontalAlignment(0);
        this.add((Component)lblTitle, gc);
        this.cboxTopic = new JComboBox();
        this.cboxTopic.setUI(new IntelComboBoxUI());
        this.cboxTopic.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this.cboxTopic);
        this.add((Component)this.cboxTopic, gc);
        this.cboxTopic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (HelpView.this.topicIdList.contains(HelpView.this.cboxTopic.getSelectedItem())) {
                    HelpView.this.helpController.showTopic((String)HelpView.this.cboxTopic.getSelectedItem());
                }
            }
        });
        this.cboxTopic.setModel(new ListComboBoxModel(this.topicIdList));
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)this.topicPanel, gc);
    }

    public List<String> getTopicIdList() {
        return this.topicIdList;
    }

    public void setTopicIdList(List<String> topicIdList) {
        this.topicIdList = topicIdList;
    }

    public void displayTopic(String topic) {
        try {
            this.topicPanel.setCurrentID(topic);
        }
        catch (BadIDException badIDException) {
            // empty catch block
        }
    }

    public void selectTopic(String topicId) {
        this.cboxTopic.setSelectedItem(topicId);
        this.helpController.showTopic((String)this.cboxTopic.getSelectedItem());
    }

    public void updateSelection(String value) {
        this.cboxTopic.setSelectedItem(value);
    }

    public void resetView() {
        this.updateSelection("");
        this.topicPanel.clear();
    }
}

