/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class IntelButtonUI
extends BasicButtonUI {
    protected int dashedRectGap = 1;
    private Color pressedColor = UIConstants.INTEL_MEDIUM_DARK_BLUE;
    private Color hoverColor = UIConstants.INTEL_MEDIUM_BLUE;
    private Color focusColor = UIConstants.INTEL_WHITE;
    private Color disabledBackgroundColor = UIConstants.INTEL_BORDER_GRAY;
    private Color disabledForegroundColor = UIConstants.INTEL_GRAY;

    public IntelButtonUI(Color hoverColor, Color pressedColor) {
        this.hoverColor = hoverColor;
        this.pressedColor = pressedColor;
    }

    public IntelButtonUI() {
    }

    public Color getPressedColor() {
        return this.pressedColor;
    }

    public void setPressedColor(Color pressedColor) {
        this.pressedColor = pressedColor;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        this.disabledBackgroundColor = disabledBackgroundColor;
    }

    public Color getDisabledForegroundColor() {
        return this.disabledForegroundColor;
    }

    public void setDisabledForegroundColor(Color disabledForegroundColor) {
        this.disabledForegroundColor = disabledForegroundColor;
    }

    public int getDashedRectGap() {
        return this.dashedRectGap;
    }

    public void setDashedRectGap(int dashedRectGap) {
        this.dashedRectGap = dashedRectGap;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled() && model.isRollover()) {
            this.paintBackground(g, b, this.getHoverColor());
        } else if (!b.isEnabled()) {
            this.paintBackground(g, b, this.getDisabledBackgroundColor());
        }
        super.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isEnabled()) {
            super.paintText(g, c, textRect, text);
        } else {
            g.setColor(this.getDisabledForegroundColor());
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = b.getDisplayedMnemonicIndex();
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.paintBackground(g, b, this.getPressedColor());
    }

    protected void paintBackground(Graphics g, AbstractButton b, Color clr) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(clr);
            g.fillRect(0, 0, size.width, size.height);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        int width = b.getWidth();
        int height = b.getHeight();
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGap, this.dashedRectGap, width - this.dashedRectGap * 2, height - this.dashedRectGap * 2);
    }
}

