/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class IntelTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color tabBackground;
    private Color tabForeground;
    private Color selectedBackground;
    private Color selectedForeground;
    private Color tabBorder;
    private Insets tabOuterInsets;
    private CtrPanel controlPanel;

    public JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new CtrPanel();
            this.controlPanel.setOpaque(false);
            if (this.tabPane != null) {
                this.tabPane.add(this.controlPanel);
            }
        }
        return this.controlPanel;
    }

    public void setTabBackground(Color tabBackground) {
        this.tabBackground = tabBackground;
    }

    public void setTabForeground(Color tabForeground) {
        this.tabForeground = tabForeground;
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackground = selectedBackground;
    }

    public void setSelectedForeground(Color selectedForeground) {
        this.selectedForeground = selectedForeground;
    }

    public void setTabBorder(Color tabBorder) {
        this.tabBorder = tabBorder;
    }

    public void setTabOuterInsets(Insets tabOuterInsets) {
        this.tabOuterInsets = tabOuterInsets;
    }

    public void setTabAreaInsets(Insets tabAreaInsets) {
        this.tabAreaInsets = tabAreaInsets;
    }

    public void setFont(Font fontStyle) {
        this.tabPane.setFont(fontStyle);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabPane.setOpaque(false);
        this.tabPane.setBackground(UIConstants.INTEL_WHITE);
        this.tabPane.setFont(UIConstants.H3_FONT.deriveFont(1));
        this.tabBorder = UIConstants.INTEL_MEDIUM_DARK_BLUE;
        this.tabBackground = UIConstants.INTEL_BLUE;
        this.tabForeground = UIConstants.INTEL_WHITE;
        this.selectedBackground = UIConstants.INTEL_WHITE;
        this.selectedForeground = UIConstants.INTEL_DARK_GRAY;
        this.tabInsets = new Insets(2, 5, 2, 5);
        this.tabOuterInsets = new Insets(1, 5, 0, 5);
        this.tabAreaInsets = new Insets(2, 5, 6, 5);
        this.selectedTabPadInsets = new Insets(2, 2, 0, 1);
        this.contentBorderInsets = new Insets(5, 2, 3, 3);
    }

    @Override
    protected void installComponents() {
        if (this.controlPanel != null) {
            this.tabPane.add(this.controlPanel);
        }
        super.installComponents();
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        if (this.controlPanel != null) {
            this.tabPane.remove(this.controlPanel);
        }
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        int height = super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
        if (this.controlPanel != null && horizRunCount > 0) {
            int w;
            int ctrHeight = this.controlPanel.getPreferredSize().height + this.tabAreaInsets.bottom;
            if (height < ctrHeight) {
                this.tabAreaInsets.top += ctrHeight - height;
                height = ctrHeight;
            }
            if (this.tabAreaInsets.right < (w = this.controlPanel.getPreferredSize().width)) {
                this.tabAreaInsets.right += w;
            }
        }
        return height;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) + this.tabOuterInsets.top + this.tabOuterInsets.bottom;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + this.tabOuterInsets.left + this.tabOuterInsets.right;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedBackground == null ? this.tabBackground : this.selectedBackground);
        switch (tabPlacement) {
            case 2: {
                throw new UnsupportedOperationException("Unsupported tab placement : LEFT");
            }
            case 4: {
                throw new UnsupportedOperationException("Unsupported tab placement : RIGHT");
            }
            case 3: {
                throw new UnsupportedOperationException("Unsupported tab placement : BOTTOM");
            }
        }
        g.fillRect(x + this.tabOuterInsets.left, y + this.tabOuterInsets.top, w - this.tabOuterInsets.left - this.tabOuterInsets.right, h - this.tabOuterInsets.top - this.tabOuterInsets.bottom);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.tabBorder);
        switch (tabPlacement) {
            case 2: {
                throw new UnsupportedOperationException("Unsupported tab placement : LEFT");
            }
            case 4: {
                throw new UnsupportedOperationException("Unsupported tab placement : RIGHT");
            }
            case 3: {
                throw new UnsupportedOperationException("Unsupported tab placement : BOTTOM");
            }
        }
        g.drawLine(x + this.tabOuterInsets.left, y + this.tabOuterInsets.top, x + w - this.tabOuterInsets.right, y + this.tabOuterInsets.top);
        g.drawLine(x + this.tabOuterInsets.left, y + this.tabOuterInsets.top, x + this.tabOuterInsets.left, y + h - this.tabOuterInsets.bottom);
        g.drawLine(x + w - this.tabOuterInsets.right, y + this.tabOuterInsets.top, x + w - this.tabOuterInsets.right, y + h - this.tabOuterInsets.bottom);
        g.drawLine(x, y + h - this.tabOuterInsets.bottom, x + this.tabOuterInsets.left, y + h - this.tabOuterInsets.bottom);
        g.drawLine(x + w - this.tabOuterInsets.right, y + h - this.tabOuterInsets.bottom, x + w, y + h - this.tabOuterInsets.bottom);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.tabBackground);
        if (tabPlacement == 1 && selectedIndex >= 0 && selRect.y + selRect.height + 1 >= y && selRect.x >= x && selRect.x <= x + w) {
            g.fillRect(x, y, selRect.x - x + this.tabOuterInsets.left + 1, this.tabAreaInsets.bottom);
            if (selRect.x + selRect.width < x + w - 2) {
                g.fillRect(selRect.x + selRect.width - this.tabOuterInsets.right, y, w - selRect.x - selRect.width + this.tabOuterInsets.right, this.tabAreaInsets.bottom);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (isSelected && this.selectedForeground != null) {
            this.tabPane.setForegroundAt(tabIndex, this.selectedForeground);
        } else {
            this.tabPane.setForegroundAt(tabIndex, this.tabForeground);
        }
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    throw new UnsupportedOperationException("Unsupported tab placement : LEFT");
                }
                case 4: {
                    throw new UnsupportedOperationException("Unsupported tab placement : LEFT");
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported tab placement : LEFT");
                }
            }
            int x = tabRect.x + this.tabOuterInsets.left + 3;
            int y = tabRect.y + this.tabOuterInsets.top + 3;
            int w = tabRect.width - this.tabOuterInsets.left - this.tabOuterInsets.right - 6;
            int h = tabRect.height - this.tabOuterInsets.top - this.tabOuterInsets.bottom - 5;
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutWrapper(super.createLayoutManager());
    }

    private class LayoutWrapper
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private final LayoutManager real;

        public LayoutWrapper(LayoutManager real) {
            super(IntelTabbedPaneUI.this);
            this.real = real;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.real.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.real.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.real.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.real.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.real.layoutContainer(parent);
            Insets insets = IntelTabbedPaneUI.this.tabPane.getInsets();
            if (IntelTabbedPaneUI.this.controlPanel != null) {
                Dimension ps = IntelTabbedPaneUI.this.controlPanel.getPreferredSize();
                int h = IntelTabbedPaneUI.this.calculateTabAreaHeight(IntelTabbedPaneUI.this.tabPane.getTabPlacement(), IntelTabbedPaneUI.this.runCount, IntelTabbedPaneUI.this.maxTabHeight);
                IntelTabbedPaneUI.this.controlPanel.setBounds(IntelTabbedPaneUI.this.tabPane.getWidth() - insets.right - ps.width, Math.max(0, h - ps.height - ((IntelTabbedPaneUI)IntelTabbedPaneUI.this).tabAreaInsets.bottom), ps.width, ps.height);
            }
        }

        @Override
        public void calculateLayoutInfo() {
            if (this.real instanceof BasicTabbedPaneUI.TabbedPaneLayout) {
                ((BasicTabbedPaneUI.TabbedPaneLayout)this.real).calculateLayoutInfo();
            }
        }
    }

    private class CtrPanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = 1L;

        private CtrPanel() {
        }
    }
}

