/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class IntelTaskPaneUI
extends BasicTaskPaneUI {
    private Font titleFont = UIConstants.H4_FONT.deriveFont(1);
    private Color titleColor = UIConstants.INTEL_DARK_GRAY;
    private Color titleOverColor = UIConstants.INTEL_BLUE;
    private Color titleBackground = UIConstants.INTEL_WHITE;
    private Color titleBorder = UIConstants.INTEL_BORDER_GRAY;
    private Color contentBackground = UIConstants.INTEL_WHITE;
    private UIImages expandImg = UIImages.UP_ICON;
    private UIImages collapseImg = UIImages.DOWN_ICON;
    private Insets contentInsets = new Insets(2, 2, 2, 2);

    protected void installDefaults() {
        super.installDefaults();
        this.group.setFont(this.titleFont);
        this.group.getContentPane().setBackground(this.contentBackground);
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public void setTitleOverColor(Color titleOverColor) {
        this.titleOverColor = titleOverColor;
    }

    public void setTitleBackground(Color titleBackground) {
        this.titleBackground = titleBackground;
    }

    public void setTitleBorder(Color titleBorder) {
        this.titleBorder = titleBorder;
    }

    public void setContentBackground(Color contentBackground) {
        this.contentBackground = contentBackground;
    }

    public void setExpandImg(UIImages expandImg) {
        this.expandImg = expandImg;
    }

    public void setCollapseImg(UIImages collapseImg) {
        this.collapseImg = collapseImg;
    }

    public void setContentInsets(Insets contentInsets) {
        this.contentInsets = contentInsets;
    }

    protected Border createPaneBorder() {
        return new IntelPaneBorder();
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder((Border)new BasicTaskPaneUI.ContentPaneBorder(borderColor), BorderFactory.createEmptyBorder(this.contentInsets.top, this.contentInsets.left, this.contentInsets.bottom, this.contentInsets.right));
    }

    class IntelPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        public IntelPaneBorder() {
            super((BasicTaskPaneUI)IntelTaskPaneUI.this);
            this.titleForeground = IntelTaskPaneUI.this.titleColor;
            this.titleBackgroundGradientStart = IntelTaskPaneUI.this.titleBackground;
            this.titleOver = IntelTaskPaneUI.this.titleOverColor;
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            super.paintTitleBackground(group, g);
            g.setColor(IntelTaskPaneUI.this.titleBorder);
            g.drawRect(0, 0, group.getWidth() - 1, IntelTaskPaneUI.this.getTitleHeight((Component)group) - 1);
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (group.isCollapsed()) {
                g.drawImage(IntelTaskPaneUI.this.collapseImg.getImage(), x, y, (ImageObserver)group);
            } else {
                g.drawImage(IntelTaskPaneUI.this.expandImg.getImage(), x, y, (ImageObserver)group);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

