/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class JCardView<E extends ICardListener>
extends JPanel {
    private static final long serialVersionUID = 381185145876115191L;
    protected E listener;
    private JComponent contentComponent;
    private String title;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JToolBar toolBar;
    private JButton helpBtn;
    private JButton pinBtn;
    private ActionListener pinListener;
    private boolean showTitle;
    private Color boderColor = UIConstants.INTEL_BORDER_GRAY;
    private int borderRound = 15;
    private int borderThick = 2;

    public JCardView(String title) {
        this(title, true);
    }

    public JCardView(String title, boolean showTitle) {
        JPanel panel;
        this.title = title;
        this.showTitle = showTitle;
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(this.borderThick, this.borderThick, this.borderThick, this.borderThick));
        this.setOpaque(false);
        if (showTitle && (panel = this.getTitlePanel(title)) != null) {
            this.add((Component)panel, "North");
        }
        this.contentComponent = this.getMainComponent();
        if (this.contentComponent != null) {
            this.contentComponent.setOpaque(false);
            this.add((Component)this.contentComponent, "Center");
        }
    }

    protected JPanel getTitlePanel(String title) {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel(new BorderLayout(0, 0));
            this.titlePanel.setOpaque(false);
            this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_PALE_BLUE));
            if (title != null) {
                this.titleLabel = ComponentFactory.getH4Label(title, 0);
                this.titleLabel.setForeground(UIConstants.INTEL_DARK_GRAY);
                this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this.titlePanel.add((Component)this.titleLabel, "West");
            }
            this.toolBar = new JToolBar();
            this.toolBar.setOpaque(false);
            this.toolBar.setFloatable(false);
            this.titlePanel.add((Component)this.toolBar, "East");
            this.addControlButtons(this.toolBar);
            JComponent comp = this.getExtraComponent();
            if (comp != null) {
                comp.setOpaque(false);
                this.titlePanel.add((Component)comp, "Center");
            }
        }
        return this.titlePanel;
    }

    protected JComponent getExtraComponent() {
        return null;
    }

    protected void addControlButtons(JToolBar toolBar) {
        this.pinBtn = ComponentFactory.getImageButton(UIImages.PIN_ICON.getImageIcon());
        this.pinBtn.setToolTipText(STLConstants.K0038_PIN_TOOLTIP.getValue());
        this.pinBtn.setEnabled(false);
        toolBar.add(this.pinBtn);
        this.helpBtn = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
        this.helpBtn.setToolTipText(STLConstants.K0037_HELP.getValue());
        this.helpBtn.setEnabled(false);
        toolBar.add(this.helpBtn);
    }

    public void setHelpButtonName(String name) {
        if (null != this.helpBtn) {
            this.helpBtn.setName(name);
        }
    }

    public void setPinButtonName(String name) {
        if (null != this.pinBtn) {
            this.pinBtn.setName(name);
        }
    }

    public void enableHelp(boolean b) {
        if (this.helpBtn != null) {
            this.helpBtn.setEnabled(b);
            this.repaint();
        }
    }

    public void enablePin(boolean b) {
        if (this.pinBtn != null) {
            this.pinBtn.setEnabled(b);
            this.repaint();
        }
    }

    protected void setPinListener() {
        if (this.pinListener != null) {
            this.pinBtn.removeActionListener(this.pinListener);
        }
        this.pinListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCardView.this.listener.onPin();
            }
        };
        this.pinBtn.addActionListener(this.pinListener);
    }

    public JButton getHelpButton() {
        return this.helpBtn;
    }

    public void setCardListener(E listener) {
        this.listener = listener;
        if (listener != null) {
            this.setPinListener();
        }
    }

    public void setTitle(String title) {
        this.setTitle(title, null);
    }

    public void setTitle(String title, String tooltip) {
        this.title = title;
        if (this.showTitle && this.titleLabel != null) {
            this.titleLabel.setText(title);
            this.titleLabel.setToolTipText(tooltip);
            this.validate();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setBoderColor(Color boderColor) {
        this.boderColor = boderColor;
    }

    public void setBorderRound(int round) {
        this.borderRound = round;
    }

    public void setBorderThick(int borderThick) {
        this.borderThick = borderThick;
    }

    protected abstract JComponent getMainComponent();

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = graphics.getStroke();
        Color oldColor = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - this.borderThick, height - this.borderThick, this.borderRound, this.borderRound);
        if (this.borderThick > 0) {
            graphics.setColor(this.boderColor);
            graphics.setStroke(new BasicStroke(this.borderThick));
            graphics.drawRoundRect(0, 0, width - this.borderThick, height - this.borderThick, this.borderRound, this.borderRound);
        }
        graphics.setStroke(oldStroke);
        graphics.setColor(oldColor);
    }
}

