/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.WidgetName;
import java.awt.Color;
import java.awt.Font;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JDuration
extends JPanel {
    private static final long serialVersionUID = 109270047037650069L;
    private long durationInSeconds;
    private long days;
    private long hours;
    private long minutes;
    private JLabel daysLabel;
    private JLabel hoursLabel;
    private JLabel minutesLabel;
    private Font numberFont;
    private Color numberColor;
    private Font labelFont;
    private Color labelColor;

    public JDuration() {
        this(-1L, TimeUnit.SECONDS);
    }

    public JDuration(long duration, TimeUnit unit) {
        this.durationInSeconds = unit.toSeconds(duration);
        this.convert();
        this.initComponent();
    }

    public void setDuration(long duration, TimeUnit unit) {
        this.durationInSeconds = unit.toSeconds(duration);
        this.convert();
        this.updateComponent();
    }

    public void setLAF(Font numberFont, Color numberColor, Font labelFont, Color labelColor) {
        this.numberFont = numberFont;
        this.numberColor = numberColor;
        this.labelFont = labelFont;
        this.labelColor = labelColor;
        this.removeAll();
        this.initComponent();
    }

    protected void convert() {
        if (this.durationInSeconds < 0L) {
            this.minutes = -1L;
            this.hours = -1L;
            this.days = -1L;
        } else {
            this.days = (int)TimeUnit.SECONDS.toDays(this.durationInSeconds);
            this.hours = TimeUnit.SECONDS.toHours(this.durationInSeconds) - this.days * 24L;
            this.minutes = TimeUnit.SECONDS.toMinutes(this.durationInSeconds) - TimeUnit.SECONDS.toHours(this.durationInSeconds) * 60L;
        }
    }

    protected void initComponent() {
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        JLabel label = null;
        if (this.days > 0L) {
            this.daysLabel = this.createNumberLabel(this.days);
            this.daysLabel.setName(WidgetName.COM_DURATION_DAYS.name());
            this.add(this.daysLabel);
            label = this.createNameLabel(STLConstants.K0009_DAYS.getValue());
            this.add(label);
        } else {
            this.daysLabel = null;
        }
        if (this.days > 0L || this.hours > 0L) {
            this.hoursLabel = this.createNumberLabel(this.hours);
            this.hoursLabel.setName(WidgetName.COM_DURATION_HOURS.name());
            this.add(this.hoursLabel);
            label = this.createNameLabel(STLConstants.K0010_HOURS.getValue());
            this.add(label);
        } else {
            this.hoursLabel = null;
        }
        this.minutesLabel = this.createNumberLabel(this.minutes);
        this.minutesLabel.setName(WidgetName.COM_DURATION_MINUTES.name());
        this.add(this.minutesLabel);
        label = this.createNameLabel(STLConstants.K0011_MINUTES.getValue());
        this.add(label);
    }

    protected void updateComponent() {
        if (this.days > 0L && this.daysLabel == null) {
            this.removeAll();
            this.initComponent();
            return;
        }
        if (this.hours > 0L && this.hoursLabel == null) {
            this.removeAll();
            this.initComponent();
            return;
        }
        if (this.daysLabel != null) {
            this.daysLabel.setText(this.getValueString(this.days));
        }
        if (this.hoursLabel != null) {
            this.hoursLabel.setText(this.getValueString(this.hours));
        }
        this.minutesLabel.setText(this.getValueString(this.minutes));
    }

    protected JLabel createNameLabel(String text) {
        JLabel res = new JLabel(text);
        res.setFont(this.labelFont);
        res.setForeground(this.labelColor);
        res.setAlignmentY(1.0f);
        res.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 6));
        return res;
    }

    protected JLabel createNumberLabel(long number) {
        String text = this.getValueString(number);
        JLabel res = new JLabel(text);
        res.setFont(this.numberFont);
        res.setForeground(this.numberColor);
        res.setAlignmentY(1.0f);
        return res;
    }

    protected String getValueString(long number) {
        return number >= 0L ? Long.toString(number) : STLConstants.K0039_NOT_AVAILABLE.getValue();
    }

    public void clear() {
        this.setDuration(-1L, TimeUnit.SECONDS);
    }
}

