/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ISectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class JSectionView<E extends ISectionListener>
extends JPanel {
    private static final long serialVersionUID = 2453671952562188530L;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel buttonPanel;
    private JButton helpBtn;
    private E listener;
    protected final JComponent mainComponent;

    public JSectionView(String title) {
        this(title, null);
    }

    public JSectionView(String title, Icon icon) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTitlePanel(title, icon), "North");
        this.mainComponent = this.getMainComponent();
        if (this.mainComponent != null) {
            this.add((Component)this.mainComponent, "Center");
        }
    }

    protected void setHelpButtonName(String name) {
        if (null != this.helpBtn) {
            this.helpBtn.setName(name);
        }
    }

    public void enableHelp(boolean b) {
        if (this.helpBtn != null) {
            this.helpBtn.setEnabled(b);
        }
    }

    public void setSectionListener(E listener) {
        this.listener = listener;
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setTitle(String title, Icon icon) {
        this.titleLabel.setText(title);
        this.titleLabel.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public JButton getHelpButton() {
        return this.helpBtn;
    }

    protected JPanel getTitlePanel(String title, Icon icon) {
        if (this.titlePanel != null) {
            return this.titlePanel;
        }
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this.titleLabel = this.createTitleLabel(title);
        this.titleLabel.setIcon(icon);
        this.titlePanel.add((Component)this.titleLabel, "West");
        this.titlePanel.add((Component)this.getButtonPanel(), "East");
        return this.titlePanel;
    }

    protected JLabel createTitleLabel(String title) {
        return ComponentFactory.getH3Label(title, 0);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel != null) {
            return this.buttonPanel;
        }
        this.buttonPanel = new JPanel();
        this.addControlButtons(this.buttonPanel);
        return this.buttonPanel;
    }

    protected void addControlButtons(JPanel panel) {
        this.helpBtn = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
        this.helpBtn.setToolTipText(STLConstants.K0037_HELP.getValue());
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSectionView.this.listener.onHelp();
            }
        });
        this.helpBtn.setEnabled(false);
        panel.add(this.helpBtn);
    }

    protected abstract JComponent getMainComponent();
}

