/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.IJumpListener;
import com.intel.stl.ui.common.view.JumpPopupUtil;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.model.FocusFlagViz;
import com.intel.stl.ui.model.PortEntry;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.entity.CategoryLabelEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;

public class JumpChartPanel
extends ChartPanel
implements ChartMouseListener {
    private static final long serialVersionUID = -5651038769029599628L;
    private JMenu jumpToMenu;
    private CategoryLabelEntity jumpToEntity;
    private CategoryAxis categoryAxis;
    private CategoryLabelEntity highlightedEntity;
    private final List<IJumpListener> listeners = new CopyOnWriteArrayList<IJumpListener>();
    private boolean jumpable;

    public JumpChartPanel(JFreeChart chart) {
        super(chart);
    }

    public void setChart(JFreeChart chart, boolean jumpable) {
        this.jumpable = jumpable;
        if (jumpable) {
            this.addChartMouseListener(this);
        } else {
            this.removeChartMouseListener(this);
        }
        super.setChart(chart);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu popup = super.createPopupMenu(properties, copy, save, print, zoom);
        this.jumpToMenu = this.addJumpMenu(popup);
        return popup;
    }

    protected JMenu addJumpMenu(JPopupMenu popup) {
        return JumpPopupUtil.appendPopupMenu(popup, true, new JumpPopupUtil.IActionCreator(){

            @Override
            public Action createAction(final JumpDestination destination) {
                return new AbstractAction(destination.getName()){
                    private static final long serialVersionUID = -2231031530367349855L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (JumpChartPanel.this.jumpToEntity != null) {
                            JumpChartPanel.this.fireJumpEvent(JumpChartPanel.this.jumpToEntity.getKey(), destination);
                        }
                    }
                };
            }
        });
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.getPopupMenu() != null) {
            ChartEntity entity = this.getEntityForPoint(x, y);
            this.jumpToEntity = entity != null && entity instanceof CategoryLabelEntity ? (CategoryLabelEntity)entity : null;
            if (this.jumpToMenu != null) {
                this.jumpToMenu.setEnabled(this.jumpable && this.jumpToEntity != null);
            }
        }
        super.displayPopupMenu(x, y);
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.highlightedEntity != null) {
            this.highlightEntity(this.highlightedEntity, false);
            this.highlightedEntity = null;
        }
    }

    public void chartMouseClicked(ChartMouseEvent cme) {
        if (!SwingUtilities.isLeftMouseButton(cme.getTrigger())) {
            return;
        }
        ChartEntity xyItem = cme.getEntity();
        if (xyItem instanceof CategoryLabelEntity) {
            this.jumpToEntity = (CategoryLabelEntity)xyItem;
            this.fireJumpEvent(this.jumpToEntity.getKey(), JumpDestination.DEFAULT);
        }
    }

    public void chartMouseMoved(ChartMouseEvent cme) {
        JPopupMenu popup = this.getPopupMenu();
        if (popup != null && popup.isShowing()) {
            return;
        }
        ChartEntity xyItem = cme.getEntity();
        if (xyItem instanceof CategoryLabelEntity) {
            CategoryLabelEntity newCatEntity = (CategoryLabelEntity)xyItem;
            if (this.highlightedEntity != null && newCatEntity.getKey().equals(this.highlightedEntity.getKey())) {
                return;
            }
            if (this.highlightedEntity != null) {
                this.highlightEntity(this.highlightedEntity, false);
            }
            this.highlightedEntity = (CategoryLabelEntity)xyItem;
            if (this.categoryAxis == null) {
                CategoryPlot plot = this.getChart().getCategoryPlot();
                this.categoryAxis = plot.getDomainAxis();
            }
            this.highlightEntity(this.highlightedEntity, true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            if (this.highlightedEntity != null) {
                this.highlightEntity(this.highlightedEntity, false);
                this.highlightedEntity = null;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void highlightEntity(CategoryLabelEntity entity, boolean highlight) {
        if (this.categoryAxis == null) {
            return;
        }
        if (highlight) {
            this.categoryAxis.setTickLabelFont(entity.getKey(), UIConstants.H5_FONT.deriveFont(1));
        } else {
            this.categoryAxis.setTickLabelFont(entity.getKey(), this.categoryAxis.getTickLabelFont());
        }
    }

    public String getToolTipText(MouseEvent e) {
        ChartEntity entity = this.getEntityForPoint(e.getX(), e.getY());
        if (entity != null) {
            if (entity instanceof CategoryLabelEntity) {
                FocusFlagViz flag;
                CategoryLabelEntity labelEntity = (CategoryLabelEntity)entity;
                Comparable key = labelEntity.getKey();
                if (key instanceof PortEntry && (flag = (FocusFlagViz)((Object)((PortEntry)key).getObject())) != null && flag != FocusFlagViz.OK) {
                    return "<html>" + key.toString() + "<br>" + flag.getValue() + "</html>";
                }
                return key.toString();
            }
            return entity.getToolTipText();
        }
        return null;
    }

    public void addListener(IJumpListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IJumpListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireJumpEvent(Object content, JumpDestination destination) {
        for (IJumpListener listener : this.listeners) {
            listener.jumpTo(content, destination);
        }
    }
}

