/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class RoundedCornersBorder
extends AbstractBorder {
    private Color color;
    private int thickness = 1;
    private final int radii = 2;
    private Insets insets = null;
    private BasicStroke stroke = null;
    private int strokePad;
    RenderingHints hints;

    public RoundedCornersBorder(Color color) {
        new RoundedCornersBorder(color, 1, 2);
    }

    public RoundedCornersBorder(Color color, int thickness, int padding) {
        this.thickness = thickness;
        this.color = color;
        this.stroke = new BasicStroke(thickness);
        this.strokePad = thickness / 2;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pad = padding + this.strokePad;
        this.insets = new Insets(pad, pad, pad, pad);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int bottomLineY = height - this.thickness;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + this.strokePad, 0 + this.strokePad, width - this.thickness, bottomLineY, 2.0, 2.0);
        Area area = new Area(bubble);
        g2.setRenderingHints(this.hints);
        Container parent = c.getParent();
        if (parent != null) {
            Color bg = parent.getBackground();
            Rectangle rect = new Rectangle(0, 0, width, height);
            Area borderRegion = new Area(rect);
            borderRegion.subtract(area);
            g2.setClip(borderRegion);
            g2.setColor(bg);
            g2.fillRect(0, 0, width, height);
            g2.setClip(null);
        }
        g2.setColor(this.color);
        g2.setStroke(this.stroke);
        g2.draw(area);
    }
}

