/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.SwitchInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class AdaptiveRoutingProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        SwitchInfoBean switchInfo = context.getSwitchInfo();
        if (switchInfo == null) {
            this.getEmptySwitchAdaptiveRouting(category);
            return;
        }
        if (switchInfo.isAdaptiveRoutingSupported()) {
            String falseStr;
            String trueStr = STLConstants.K0385_TRUE.getValue();
            String value = falseStr = STLConstants.K0386_FALSE.getValue();
            if (switchInfo.isAdaptiveRoutingEnable()) {
                value = trueStr;
            }
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_ENABLE, value);
            value = falseStr;
            if (switchInfo.isAdaptiveRoutingPause()) {
                value = trueStr;
            }
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_PAUSE, value);
            value = falseStr;
            if (switchInfo.isAdaptiveRoutingLostRoutesOnly()) {
                value = trueStr;
            }
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_LOST, value);
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_FREQ, AdaptiveRoutingProcessor.dec(switchInfo.getAdaptiveRoutingFrequency()));
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_ALGORITHM, AdaptiveRoutingProcessor.dec(switchInfo.getAdaptiveRoutingAlgorithm()));
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING_THRESHOLD, AdaptiveRoutingProcessor.dec(switchInfo.getAdaptiveRoutingThreshold()));
        } else {
            AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING, STLConstants.K0444_NOT_SUPPORTED.getValue());
        }
    }

    private void getEmptySwitchAdaptiveRouting(DevicePropertyCategory category) {
        AdaptiveRoutingProcessor.addProperty(category, DeviceProperty.ADAPTIVE_ROUTING, STLConstants.K0383_NA.getValue());
    }
}

