/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.LinkWidthMask;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.configuration.ResourceCategoryProcessor;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.LinkWidthMaskViz;
import java.util.List;

public abstract class BaseCategoryProcessor
implements ResourceCategoryProcessor {
    @Override
    public abstract void process(ICategoryProcessorContext var1, DevicePropertyCategory var2);

    protected static void addProperty(DevicePropertyCategory category, DeviceProperty key, String value) {
        DevicePropertyItem property = new DevicePropertyItem(key, (Object)value);
        category.addPropertyItem(property);
    }

    protected static String getLinkWidthString(short val) {
        StringBuilder lwStr = new StringBuilder();
        String join = "";
        String or = " " + STLConstants.K0388_OR.getValue() + " ";
        List<LinkWidthMask> masks = LinkWidthMask.getWidthMasks(val);
        for (LinkWidthMask mask : masks) {
            lwStr.append(join);
            lwStr.append(LinkWidthMaskViz.getLinkWidthMaskStr(mask));
            join = or;
        }
        return lwStr.toString();
    }

    protected static String hex(long value) {
        return StringUtils.longHexString(value);
    }

    protected static String hex(short value) {
        return StringUtils.shortHexString(value);
    }

    protected static String hex(int value) {
        return StringUtils.intHexString(value);
    }

    protected static String hex(byte value) {
        return StringUtils.byteHexString(value);
    }

    protected static String dec(byte value) {
        int unsignedValue = value & 0xFF;
        return Integer.toString(unsignedValue);
    }

    protected static String dec(int value) {
        long unsignedValue = value & 0xFFFFFFFF;
        return Long.toString(unsignedValue);
    }

    protected static String dec(short value) {
        int unsignedValue = value & 0xFFFF;
        return Integer.toString(unsignedValue);
    }

    protected static String getIpV6Addr(byte[] ipBytes) {
        if (ipBytes == null || BaseCategoryProcessor.isZeros(ipBytes)) {
            return STLConstants.K0383_NA.getValue();
        }
        return StringUtils.getIpV6Addr(ipBytes);
    }

    protected static String getIpV4Addr(byte[] ipBytes) {
        if (ipBytes == null || BaseCategoryProcessor.isZeros(ipBytes)) {
            return STLConstants.K0383_NA.getValue();
        }
        return StringUtils.getIpV4Addr(ipBytes);
    }

    protected static boolean isZeros(byte[] ipBytes) {
        for (byte val : ipBytes) {
            if (val == 0) continue;
            return false;
        }
        return true;
    }
}

