/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class BufferUnitsProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo == null) {
            this.getEmptyPortBufferUnits(category);
            return;
        }
        BufferUnitsProcessor.addProperty(category, DeviceProperty.VL15_INIT, BufferUnitsProcessor.hex(portInfo.getVl15Init()));
        if (isExternalSWPort || isHFI) {
            BufferUnitsProcessor.addProperty(category, DeviceProperty.VL15_CREDIT_RATE, BufferUnitsProcessor.hex(portInfo.getVl15CreditRate()));
            BufferUnitsProcessor.addProperty(category, DeviceProperty.CREDIT_ACK, BufferUnitsProcessor.hex(portInfo.getCreditAck()));
        } else {
            BufferUnitsProcessor.addProperty(category, DeviceProperty.VL15_CREDIT_RATE, STLConstants.K0383_NA.getValue());
            BufferUnitsProcessor.addProperty(category, DeviceProperty.CREDIT_ACK, STLConstants.K0383_NA.getValue());
        }
        BufferUnitsProcessor.addProperty(category, DeviceProperty.BUFFER_ALLOC, BufferUnitsProcessor.hex(portInfo.getBufferAlloc()));
    }

    private void getEmptyPortBufferUnits(DevicePropertyCategory category) {
        BufferUnitsProcessor.addProperty(category, DeviceProperty.VL15_INIT, "");
        BufferUnitsProcessor.addProperty(category, DeviceProperty.VL15_CREDIT_RATE, "");
        BufferUnitsProcessor.addProperty(category, DeviceProperty.CREDIT_ACK, "");
        BufferUnitsProcessor.addProperty(category, DeviceProperty.BUFFER_ALLOC, "");
    }
}

