/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.CableInfoBean;
import com.intel.stl.api.subnet.CableRecordBean;
import com.intel.stl.api.subnet.CertifiedRateType;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.PowerClassType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.CableTypeViz;
import com.intel.stl.ui.model.CertifiedRateTypeViz;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.PortTypeViz;
import com.intel.stl.ui.model.PowerClassTypeViz;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.Date;
import java.util.List;

public class CableInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        FVResourceNode node = context.getResourceNode();
        PortRecordBean portBean = context.getPort();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        if (portBean == null || portBean.getPortNum() == 0 && node.getParent().getType() == TreeNodeType.SWITCH) {
            this.getCableInfo(category, null);
            return;
        }
        List<CableRecordBean> cableRecordBeans = subnetApi.getCable(portBean.getEndPortLID(), portBean.getPortNum());
        if (cableRecordBeans == null || cableRecordBeans.isEmpty()) {
            this.getCableInfo(category, null);
            return;
        }
        for (CableRecordBean cableBean : cableRecordBeans) {
            if (cableBean.getPortType() == PortTypeViz.STANDARD.getPortType().getValue()) continue;
            this.getCableInfo(category, null);
            return;
        }
        CableInfoBean cableInfoBean = new CableInfoBean();
        for (CableRecordBean cableBean : cableRecordBeans) {
            this.combineCableInfo(cableInfoBean, cableBean.getCableInfo());
        }
        this.getCableInfo(category, cableInfoBean);
    }

    private void combineCableInfo(CableInfoBean destination, CableInfoBean source) {
        CertifiedRateType certDataRate;
        Integer reachClass;
        Boolean certCableFlag;
        Byte ccExt;
        Date date;
        String dateCode;
        String vendorSN;
        Boolean memPage01Provided;
        Boolean memPage02Provided;
        Boolean txSquelchImp;
        Boolean rxCDROnOffCtrl;
        Boolean txCDROnOffCtrl;
        Boolean rxOutpAmplFixProg;
        Boolean rxOutpEmphFixProg;
        Boolean txInpEqFixProg;
        Boolean txInpEqAutoAdp;
        Byte ccBase;
        Integer maxCaseTemp;
        String vendorRev;
        String vendorPn;
        Byte[] vendorOui;
        String vendorName;
        Byte xmitTech;
        Integer om4Len;
        Integer om2Len;
        Integer om3Len;
        Byte bitRateLow;
        Byte bitRateHigh;
        Byte connector;
        Boolean rxCDRSupported;
        Boolean txCDRSupported;
        PowerClassType extId;
        Byte id = source.getId();
        if (id != null) {
            destination.setId(id);
        }
        if ((extId = source.getPowerClass()) != null) {
            destination.setPowerClass(extId);
        }
        if ((txCDRSupported = source.getTxCDRSupported()) != null) {
            destination.setTxCDRSupported(txCDRSupported);
        }
        if ((rxCDRSupported = source.getRxCDRSupported()) != null) {
            destination.setRxCDRSupported(rxCDRSupported);
        }
        if ((connector = source.getConnector()) != null) {
            destination.setConnector(connector);
        }
        if ((bitRateHigh = source.getBitRateHigh()) != null) {
            destination.setBitRateHigh(bitRateHigh);
        }
        if ((bitRateLow = source.getBitRateLow()) != null) {
            destination.setBitRateLow(bitRateLow);
        }
        if ((om3Len = source.getOm3Length()) != null) {
            destination.setOm3Length(om3Len);
        }
        if ((om2Len = source.getOm2Length()) != null) {
            destination.setOm2Length(om2Len);
        }
        if ((om4Len = source.getOm4Length()) != null) {
            destination.setOm4Length(om4Len);
        }
        if ((xmitTech = source.getXmitTech()) != null) {
            destination.setXmitTech(xmitTech);
        }
        if ((vendorName = source.getVendorName()) != null) {
            destination.setVendorName(vendorName);
        }
        if ((vendorOui = source.getVendorOui()) != null) {
            destination.setVendorOui(vendorOui);
        }
        if ((vendorPn = source.getVendorPn()) != null) {
            destination.setVendorPn(vendorPn);
        }
        if ((vendorRev = source.getVendorRev()) != null) {
            destination.setVendorRev(vendorRev);
        }
        if ((maxCaseTemp = source.getMaxCaseTemp()) != null) {
            destination.setMaxCaseTemp(maxCaseTemp);
        }
        if ((ccBase = source.getCcBase()) != null) {
            destination.setCcBase(ccBase);
        }
        if ((txInpEqAutoAdp = source.getTxInpEqAutoAdp()) != null) {
            destination.setTxInpEqAutoAdp(txInpEqAutoAdp);
        }
        if ((txInpEqFixProg = source.getTxInpEqFixProg()) != null) {
            destination.setTxInpEqFixProg(txInpEqFixProg);
        }
        if ((rxOutpEmphFixProg = source.getRxOutpEmphFixProg()) != null) {
            destination.setRxOutpEmphFixProg(rxOutpEmphFixProg);
        }
        if ((rxOutpAmplFixProg = source.getRxOutpAmplFixProg()) != null) {
            destination.setRxOutpAmplFixProg(rxOutpAmplFixProg);
        }
        if ((txCDROnOffCtrl = source.getTxCDROnOffCtrl()) != null) {
            destination.setTxCDROnOffCtrl(txCDROnOffCtrl);
        }
        if ((rxCDROnOffCtrl = source.getRxCDROnOffCtrl()) != null) {
            destination.setRxCDROnOffCtrl(rxCDROnOffCtrl);
        }
        if ((txSquelchImp = source.isTxSquelchImp()) != null) {
            destination.setTxSquelchImp(txSquelchImp);
        }
        if ((memPage02Provided = source.isMemPage02Provided()) != null) {
            destination.setMemPage02Provided(memPage02Provided);
        }
        if ((memPage01Provided = source.isMemPage01Provided()) != null) {
            destination.setMemPage01Provided(memPage01Provided);
        }
        if ((vendorSN = source.getVendorSN()) != null) {
            destination.setVendorSN(vendorSN);
        }
        if ((dateCode = source.getDateCode()) != null) {
            destination.setDateCode(dateCode);
        }
        if ((date = source.getDateCodeAsDate()) != null) {
            destination.setDate(date);
        }
        if ((ccExt = source.getCcExt()) != null) {
            destination.setCcExt(ccExt);
        }
        if ((certCableFlag = source.getCertCableFlag()) != null) {
            destination.setCertCableFlag(certCableFlag);
        }
        if ((reachClass = source.getReachClass()) != null) {
            destination.setReachClass(reachClass);
        }
        if ((certDataRate = source.getCertDataRate()) != null) {
            destination.setCertDataRate(certDataRate);
        }
    }

    public void getCableInfo(DevicePropertyCategory category, CableInfoBean bean) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        if (bean != null) {
            block94: {
                Byte id = bean.getId();
                if (id != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, CableInfoProcessor.hex(id));
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, na);
                }
                PowerClassType powerClass = bean.getPowerClass();
                if (powerClass != null) {
                    try {
                        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, PowerClassTypeViz.getPowerClassTypeVizFor(powerClass).getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
                }
                Boolean txCDRSupported = bean.getTxCDRSupported();
                if (txCDRSupported != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_SUP, txCDRSupported != false ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_SUP, na);
                }
                Boolean rxCDRSupported = bean.getTxCDRSupported();
                if (rxCDRSupported != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_SUP, rxCDRSupported != false ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_SUP, na);
                }
                Byte connector = bean.getConnector();
                if (connector != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CONNECTOR, CableInfoProcessor.hex(connector));
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CONNECTOR, na);
                }
                Byte bitRateLow = bean.getBitRateLow();
                Byte bitRateHigh = bean.getBitRateHigh();
                if (bitRateLow != null && bitRateHigh != null) {
                    Integer nominalBr = bean.stlCableInfoBitRate(bitRateLow, bitRateHigh);
                    if (nominalBr != null) {
                        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, nominalBr.toString() + " " + STLConstants.K1152_CABLE_GB.getValue());
                    } else {
                        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, na);
                    }
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, na);
                }
                Integer om2Length = bean.getOm2Length();
                if (om2Length != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM2_LEN, Integer.toString(om2Length) + " " + STLConstants.K1154_CABLE_M.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM2_LEN, na);
                }
                Integer om3Length = bean.getOm3Length();
                if (om3Length != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM3_LEN, Integer.toString(om3Length) + " " + STLConstants.K1154_CABLE_M.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM3_LEN, na);
                }
                Integer om4Length = bean.getOm4Length();
                if (om4Length != null) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_COPPER_LEN, Integer.toString(om4Length) + " " + STLConstants.K1154_CABLE_M.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_COPPER_LEN, na);
                }
                Byte xmitTech = bean.getXmitTech();
                Byte codeConnector = bean.getConnector();
                if (xmitTech != null && codeConnector != null) {
                    try {
                        CableTypeViz cableType = CableTypeViz.getCableTypeVizFor(bean.stlCableInfoCableType(xmitTech.intValue(), codeConnector));
                        if (cableType != null) {
                            CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, cableType.getName());
                            break block94;
                        }
                        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
                }
            }
            String vendorName = bean.getVendorName();
            if (vendorName != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, vendorName);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
            }
            Byte[] vendorOui = bean.getVendorOui();
            if (vendorOui != null) {
                StringBuilder sb = new StringBuilder(vendorOui.length * 2);
                sb.append("0x");
                Byte[] arr$ = vendorOui;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    byte b = arr$[i$];
                    sb.append(String.format("%02x", b));
                }
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, sb.toString());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
            }
            String vendorPN = bean.getVendorPn();
            if (vendorPN != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, vendorPN);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
            }
            String vendorRev = bean.getVendorRev();
            if (vendorRev != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, vendorRev);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
            }
            Integer maxCaseTemp = bean.getMaxCaseTemp();
            if (maxCaseTemp != null) {
                if (maxCaseTemp > 0) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, Integer.toString(maxCaseTemp) + " " + STLConstants.K1158_CABLE_C.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, STLConstants.K1159_NOT_INDICATED.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, na);
            }
            Byte ccBase = bean.getCcBase();
            if (ccBase != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_BASE, CableInfoProcessor.hex(bean.getCcBase()));
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_BASE, na);
            }
            Boolean txInpEqAutoAdp = bean.getTxInpEqAutoAdp();
            if (txInpEqAutoAdp != null) {
                if (txInpEqAutoAdp.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, na);
            }
            Boolean txInpEqFixProg = bean.getTxInpEqFixProg();
            if (txInpEqFixProg != null) {
                if (txInpEqFixProg.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, na);
            }
            Boolean rxOutpEmphFixProg = bean.getRxOutpEmphFixProg();
            if (rxOutpEmphFixProg != null) {
                if (rxOutpEmphFixProg.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, na);
            }
            Boolean rxOutpAmplFixProg = bean.getRxOutpAmplFixProg();
            if (rxOutpAmplFixProg != null) {
                if (rxOutpAmplFixProg.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, na);
            }
            Boolean txCDROnOffCtrl = bean.getTxCDROnOffCtrl();
            if (txCDROnOffCtrl != null) {
                if (txCDROnOffCtrl.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, na);
            }
            Boolean rxCDROnOffCtrl = bean.getRxCDROnOffCtrl();
            if (rxCDROnOffCtrl != null) {
                if (rxCDROnOffCtrl.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, na);
            }
            Boolean txSquelchImp = bean.isTxSquelchImp();
            if (txSquelchImp != null) {
                if (txSquelchImp.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, na);
            }
            Boolean memPage02Provided = bean.isMemPage02Provided();
            if (memPage02Provided != null) {
                if (memPage02Provided.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, na);
            }
            Boolean memPage01Provided = bean.isMemPage01Provided();
            if (memPage01Provided != null) {
                if (memPage01Provided.booleanValue()) {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, STLConstants.K0385_TRUE.getValue());
                } else {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, STLConstants.K0386_FALSE.getValue());
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, na);
            }
            String vendorSn = bean.getVendorSN();
            if (vendorSn != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, vendorSn);
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
            }
            String dateCode = bean.getDateCode();
            if (dateCode != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, "20" + dateCode);
            } else {
                String beanDateCode = bean.getDateCode();
                dateCode = beanDateCode != null ? STLConstants.K1116_INVALID.getValue() : na;
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, dateCode);
            }
            Byte ccExt = bean.getCcExt();
            if (ccExt != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_EXT, CableInfoProcessor.hex(ccExt));
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_EXT, na);
            }
            Boolean ccFlag = bean.getCertCableFlag();
            if (ccFlag != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_CABLE_FLAG, ccFlag != false ? STLConstants.K1155_CABLE_Y.getValue() : STLConstants.K1156_CABLE_N.getValue());
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_CABLE_FLAG, na);
            }
            Integer reachClass = bean.getReachClass();
            if (reachClass != null) {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_REACH_CLASS, Integer.toString(reachClass));
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_REACH_CLASS, na);
            }
            CertifiedRateType certDataRate = bean.getCertDataRate();
            if (certDataRate != null) {
                try {
                    CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, CertifiedRateTypeViz.getCertifiedRateTypeVizFor(certDataRate).getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, na);
            }
        } else {
            this.getNullCableInfo(category);
        }
    }

    private void getNullCableInfo(DevicePropertyCategory category) {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_ID, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_POWER_CLASS, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_SUP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_SUP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CONNECTOR, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_NOMINAL_BR, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM2_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_OM3_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_COPPER_LEN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DEVICE_TECH, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_NAME, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_OUI, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_PN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_REV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MAXCASE_TEMP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_BASE, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_TX_SQUELCH_IMP, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE02_PROV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_MEM_PAGE01_PROV, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_VENDOR_SN, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_DATE_CODE, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CC_EXT, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_CABLE_FLAG, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_REACH_CLASS, na);
        CableInfoProcessor.addProperty(category, DeviceProperty.CABLE_CERT_DATA_RATE, na);
    }
}

