/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;

public class HoQLifeProcessor
extends BaseCategoryProcessor {
    private static double INFINITE = 10000.0;

    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo != null) {
            this.getHoQLife(category, portInfo.getHoqLife());
        }
    }

    private void getHoQLife(DevicePropertyCategory category, byte[] hoqLife) {
        double[] series = new double[hoqLife.length];
        for (int i = 0; i < series.length; ++i) {
            series[i] = Utils.getHoQLife(hoqLife[i]);
            if (series[i] != Double.POSITIVE_INFINITY) continue;
            series[i] = INFINITE;
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.HOQLIFE, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem numVLs = new DevicePropertyItem(DeviceProperty.NUM_VL, (Object)new Integer(32));
        category.addPropertyItem(numVLs);
    }

    public static String getHoqLifeString(double hoqLife) {
        String hoqString = null;
        hoqString = hoqLife >= INFINITE ? STLConstants.K0133_INFINITE.getValue() : (hoqLife < 1.0 ? (int)(hoqLife * 1024.0) + " " + STLConstants.K0131_US.getValue() : (hoqLife >= 1024.0 ? (int)(hoqLife / 1024.0) + " " + STLConstants.K0132_S.getValue() : (int)hoqLife + " " + STLConstants.K0130_MS.getValue()));
        return hoqString;
    }
}

