/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.ArrayList;
import java.util.List;

public class LFTSeriesProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        int lid;
        FVResourceNode node = context.getResourceNode();
        NodeInfoBean nodeInfo = context.getNodeInfo();
        if (nodeInfo == null) {
            double[] series = new double[1];
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.LFT_SERIES, (Object)series);
            category.addPropertyItem(property);
            DevicePropertyItem numPorts = new DevicePropertyItem(DeviceProperty.NUM_PORTS, (Object)new Integer(0));
            category.addPropertyItem(numPorts);
            return;
        }
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        List<LFTRecordBean> lftRecs = subnetApi.getLFT(lid = node.getId());
        if (lftRecs == null) {
            return;
        }
        ArrayList<Double> lftSeries = new ArrayList<Double>();
        for (LFTRecordBean lft : lftRecs) {
            lid = lft.getBlockNum() * 64;
            byte[] retPts = lft.getLinearFdbData();
            int i = 0;
            while (i < retPts.length) {
                if (retPts[i] != -1) {
                    String doubleValue = LFTSeriesProcessor.dec((short)(retPts[i] & 0xFF)) + "." + lid;
                    lftSeries.add(Double.parseDouble(doubleValue));
                }
                ++i;
                ++lid;
            }
        }
        double[] series = new double[lftSeries.size()];
        for (int i = 0; i < lftSeries.size(); ++i) {
            series[i] = (Double)lftSeries.get(i);
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.LFT_SERIES, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem numPorts = new DevicePropertyItem(DeviceProperty.NUM_PORTS, (Object)new Integer(nodeInfo.getNumPorts()));
        category.addPropertyItem(numPorts);
    }
}

