/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortDownReasonBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.LinkDownReasonViz;

public class LinkDownErrorLogProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortDownReasonBean[] portDownReasons;
        PortRecordBean portBean = context.getPort();
        if (portBean == null) {
            return;
        }
        for (PortDownReasonBean bean : portDownReasons = portBean.getLinkDownReasons()) {
            if (bean.getTimestamp() == 0L) continue;
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.LINK_DOWN_REASON, bean.getTimestampDate().toString(), (Object)LinkDownReasonViz.getLinkDownReasonStr(bean.getLinkDownReason()));
            category.addPropertyItem(property);
        }
        if (category.getItems().isEmpty()) {
            String none = STLConstants.K0056_NONE.getValue();
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.LINK_DOWN_REASON, none, (Object)none);
            category.addPropertyItem(property);
        }
    }
}

