/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.CapabilityMask;
import com.intel.stl.api.configuration.CapabilityMask3;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class PortCapabilitiesProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo != null) {
            String trueStr = STLConstants.K0385_TRUE.getValue();
            String falseStr = STLConstants.K0386_FALSE.getValue();
            int val = portInfo.getCapabilityMask();
            String value = falseStr;
            if (CapabilityMask.HAS_SM.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.SUBNET_MANAGER, value);
            value = falseStr;
            if (CapabilityMask.HAS_NOTICE.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.NOTICE_SUPPORTED, value);
            value = falseStr;
            if (CapabilityMask.HAS_AUTOMIGRATION.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.AUTO_MIGR_SUPPORTED, value);
            value = falseStr;
            if (CapabilityMask.HAS_CONNECTIONMANAGEMENT.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.CONN_LABEL_SUPPORTED, value);
            value = falseStr;
            if (CapabilityMask.HAS_DEVICEMANAGEMENT.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.DEVICE_MGMT_SUPPORTED, value);
            value = falseStr;
            if (CapabilityMask.HAS_VENDORCLASS.hasThisMask(val)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.VENDOR_CLASS_SUPPORTED, value);
            short val3 = portInfo.getCapabilityMask3();
            value = falseStr;
            if (CapabilityMask3.SNOOP_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_SNOOP, value);
            value = falseStr;
            if (CapabilityMask3.ASYNCSC2VL_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_ASYNC_SC2VL, value);
            value = falseStr;
            if (CapabilityMask3.ADDRRANGECONFIG_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_ADRR_RANGE_CONFIG, value);
            value = falseStr;
            if (CapabilityMask3.PASSTHROUGH_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_PASSTHRU, value);
            value = falseStr;
            if (CapabilityMask3.SHAREDSPACE_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_SHARED_SPACE, value);
            value = falseStr;
            if (CapabilityMask3.VLMARKER_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_VL_MARKER, value);
            value = falseStr;
            if (CapabilityMask3.VLR_SUPPORTED.hasThisMask(val3)) {
                value = trueStr;
            }
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_VLR, value);
        } else {
            String na = STLConstants.K0383_NA.getValue();
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.SUBNET_MANAGER, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.NOTICE_SUPPORTED, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.AUTO_MIGR_SUPPORTED, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.CONN_LABEL_SUPPORTED, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.DEVICE_MGMT_SUPPORTED, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.VENDOR_CLASS_SUPPORTED, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_SNOOP, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_ASYNC_SC2VL, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_ADRR_RANGE_CONFIG, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_PASSTHRU, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_SHARED_SPACE, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_VL15_MULTICAST, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_VL_MARKER, na);
            PortCapabilitiesProcessor.addProperty(category, DeviceProperty.PORT_VLR, na);
        }
    }
}

