/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import java.util.ArrayList;

public class SC2VLNTMTProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortRecordBean portBean = context.getPort();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        if (portBean == null || portBean.getEndPortLID() == 0) {
            return;
        }
        SC2VLMTRecordBean sc2vlntmtRec = subnetApi.getSC2VLNTMT(portBean.getEndPortLID(), portBean.getPortNum());
        if (sc2vlntmtRec == null) {
            return;
        }
        this.getSC2VLNTMT(category, sc2vlntmtRec.getData());
    }

    private void getSC2VLNTMT(DevicePropertyCategory category, byte[] sc2vlnt) {
        ArrayList<Double> sc2vlntSeries = new ArrayList<Double>();
        for (int i = 0; i < sc2vlnt.length; ++i) {
            String doubleValue = SC2VLNTMTProcessor.dec((short)(sc2vlnt[i] & 0xFF));
            sc2vlntSeries.add(Double.parseDouble(doubleValue));
        }
        double[] series = new double[sc2vlntSeries.size()];
        for (int i = 0; i < sc2vlntSeries.size(); ++i) {
            series[i] = (Double)sc2vlntSeries.get(i);
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.VLNT, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem sc = new DevicePropertyItem(DeviceProperty.SC, (Object)new Integer(32));
        category.addPropertyItem(sc);
    }
}

