/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.configuration.PropertyCategoryController;
import com.intel.stl.ui.configuration.view.DefaultPropertyRenderer;
import com.intel.stl.ui.configuration.view.PropertyCategoryPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.framework.AbstractView;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.PropertyItem;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.hyperlink.HyperlinkAction;

public class DevicePropertyCategoryPanel
extends AbstractView<DevicePropertyCategory, PropertyCategoryController> {
    private static final long serialVersionUID = 1L;
    protected PropertyCategoryPanel propsPanel;
    protected PropertyVizStyle style;

    public DevicePropertyCategoryPanel() {
        this(new PropertyVizStyle());
    }

    public DevicePropertyCategoryPanel(PropertyVizStyle style) {
        this.style = style;
    }

    @Override
    public void modelUpdateFailed(DevicePropertyCategory model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        this.propsPanel.setModel(model);
    }

    @Override
    public JComponent getMainComponent() {
        if (this.propsPanel == null) {
            this.propsPanel = new PropertyCategoryPanel(this.style);
            this.propsPanel.setPropertyRenderer(new DefaultPropertyRenderer(){

                @Override
                public Component getValueComponent(PropertyItem<?> item, int itemIndex, int row, PropertyVizStyle style) {
                    Object key = item.getKey();
                    if (key instanceof DeviceProperty) {
                        DeviceProperty dp = (DeviceProperty)key;
                        URI uri = null;
                        String address = item.getValue();
                        try {
                            if (dp == DeviceProperty.IP_ADDR_IPV6) {
                                uri = DevicePropertyCategoryPanel.this.getIPv6URI(address);
                            } else if (dp == DeviceProperty.IP_ADDR_IPV4 || dp == DeviceProperty.IPCHASSIS_NAME) {
                                uri = DevicePropertyCategoryPanel.this.getIPv4URI(address);
                            }
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        if (uri != null) {
                            HyperlinkAction action = HyperlinkAction.createHyperlinkAction((URI)uri);
                            action.putValue("Name", address);
                            JXHyperlink link = new JXHyperlink((Action)action);
                            link.setUnclickedColor(UIConstants.INTEL_BLUE);
                            link.setToolTipText(uri.toString());
                            link.setBorderPainted(true);
                            link.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 2));
                            style.decorateValue((JComponent)link, itemIndex);
                            return link;
                        }
                    }
                    return super.getValueComponent(item, itemIndex, row, style);
                }
            });
        }
        return this.propsPanel;
    }

    protected URI getIPv6URI(String address) throws URISyntaxException {
        URI uri = null;
        if (address != null && address.length() > 2 && address.indexOf(58) >= 0) {
            uri = new URI("http://[" + address + "]");
        }
        return uri;
    }

    protected URI getIPv4URI(String address) throws URISyntaxException {
        URI uri = null;
        if (address != null && address.indexOf(46) > 0) {
            uri = new URI("http://" + address);
        }
        return uri;
    }

    @Override
    public void initComponents() {
    }
}

