/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.ui.configuration.HoQLifeBarChartController;
import com.intel.stl.ui.configuration.LFTHistogramController;
import com.intel.stl.ui.configuration.MTUByVLBarChartController;
import com.intel.stl.ui.configuration.MultiColumnCategoryController;
import com.intel.stl.ui.configuration.PropertyCategoryController;
import com.intel.stl.ui.configuration.PropertyGroupController;
import com.intel.stl.ui.configuration.SC2SLMTBarChartController;
import com.intel.stl.ui.configuration.SC2VLNTMTBarChartController;
import com.intel.stl.ui.configuration.SC2VLTMTBarChartController;
import com.intel.stl.ui.configuration.VLStallCountByVLBarChartController;
import com.intel.stl.ui.configuration.view.DevicePropertyCategoryPanel;
import com.intel.stl.ui.configuration.view.HoQLifeBarChartPanel;
import com.intel.stl.ui.configuration.view.LFTHistogramPanel;
import com.intel.stl.ui.configuration.view.MTUByVLBarChartPanel;
import com.intel.stl.ui.configuration.view.MultiColumnCategoryPanel;
import com.intel.stl.ui.configuration.view.PagingCategoryPanel;
import com.intel.stl.ui.configuration.view.PropertyGroupPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.configuration.view.SC2SLMTBarChartPanel;
import com.intel.stl.ui.configuration.view.SC2VLNTMTBarChartPanel;
import com.intel.stl.ui.configuration.view.SC2VLTMTBarChartPanel;
import com.intel.stl.ui.configuration.view.VLStallCountByVLBarChartPanel;
import com.intel.stl.ui.framework.AbstractView;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyGroup;
import java.awt.Component;
import javax.swing.JComponent;

public class DevicePropertyGroupPanel
extends AbstractView<DevicePropertyGroup, PropertyGroupController> {
    private static final long serialVersionUID = 4539967617107147387L;
    private GroupPanel mainPanel;
    protected PropertyVizStyle style;

    public DevicePropertyGroupPanel(PropertyVizStyle style) {
        this.style = style;
    }

    @Override
    public void modelUpdateFailed(DevicePropertyGroup model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyGroup model) {
        this.mainPanel.setModel(model);
    }

    @Override
    public JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new GroupPanel(this.style);
        }
        return this.mainPanel;
    }

    @Override
    public void initComponents() {
    }

    public void enableHelp(boolean b) {
        if (this.mainPanel == null) {
            throw new RuntimeException("No panel initialized");
        }
        this.mainPanel.enableHelp(b);
    }

    public Component getHelpButton() {
        if (this.mainPanel == null) {
            throw new RuntimeException("No panel initialized");
        }
        return this.mainPanel.getHelpButton();
    }

    class GroupPanel
    extends PropertyGroupPanel<DevicePropertyCategory, DevicePropertyGroup> {
        private static final long serialVersionUID = 6635431613502243647L;

        public GroupPanel(PropertyVizStyle style) {
            super(style);
        }

        @Override
        protected Component createCategoryPanel(DevicePropertyCategory category, PropertyVizStyle style) {
            AbstractView categoryPanel;
            if (category.size() < 26) {
                if (category.getCategory() == ResourceCategory.LFT_HISTOGRAM) {
                    categoryPanel = new LFTHistogramPanel();
                    new LFTHistogramController(category, (LFTHistogramPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.SC2SLMT_CHART) {
                    categoryPanel = new SC2SLMTBarChartPanel();
                    new SC2SLMTBarChartController(category, (SC2SLMTBarChartPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.SC2VLTMT_CHART) {
                    categoryPanel = new SC2VLTMTBarChartPanel();
                    new SC2VLTMTBarChartController(category, (SC2VLTMTBarChartPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.SC2VLNTMT_CHART) {
                    categoryPanel = new SC2VLNTMTBarChartPanel();
                    new SC2VLNTMTBarChartController(category, (SC2VLNTMTBarChartPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.MTU_CHART) {
                    categoryPanel = new MTUByVLBarChartPanel();
                    new MTUByVLBarChartController(category, (MTUByVLBarChartPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.HOQLIFE_CHART) {
                    categoryPanel = new HoQLifeBarChartPanel();
                    new HoQLifeBarChartController(category, (HoQLifeBarChartPanel)categoryPanel, null);
                } else if (category.getCategory() == ResourceCategory.VL_STALL_CHART) {
                    categoryPanel = new VLStallCountByVLBarChartPanel();
                    new VLStallCountByVLBarChartController(category, (VLStallCountByVLBarChartPanel)categoryPanel, null);
                } else {
                    categoryPanel = new DevicePropertyCategoryPanel(style);
                    new PropertyCategoryController(category, (DevicePropertyCategoryPanel)categoryPanel, null);
                }
            } else {
                categoryPanel = category.size() < 51 ? new MultiColumnCategoryPanel(2, style) : new PagingCategoryPanel(2, 16, 5, style);
                new MultiColumnCategoryController(category, (MultiColumnCategoryPanel)categoryPanel, null);
            }
            return categoryPanel;
        }
    }
}

