/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.view.DevicePropertyCategoryPanel;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import java.awt.Component;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SC2VLNTMTBarChartPanel
extends DevicePropertyCategoryPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SC2VLNTMTBarChartPanel.class);
    private static final Dimension PREFERRED_CHART_SIZE = new Dimension(360, 240);
    private XYSeriesCollection dataset;
    private ChartPanel chartPanel;

    @Override
    public void modelUpdateFailed(DevicePropertyCategory model, Throwable caught) {
    }

    @Override
    public void modelChanged(DevicePropertyCategory model) {
        try {
            double[] values = (double[])model.getProperty(DeviceProperty.VLNT).getObject();
            int numSCs = (Integer)model.getProperty(DeviceProperty.SC).getObject();
            XYSeries xyseries = new XYSeries((Comparable)((Object)""));
            int x = 0;
            for (double v : values) {
                xyseries.add((double)x++, v);
            }
            this.dataset.addSeries(xyseries);
            this.chartPanel.getChart().getXYPlot().getDomainAxis().setRange(0.0, (double)numSCs);
        }
        catch (Exception e) {
            log.warn("Failed to display model because of '" + e.getMessage() + "'");
            this.propsPanel.remove((Component)this.chartPanel);
            this.propsPanel.add(ComponentFactory.getH4Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0));
        }
    }

    @Override
    public void initComponents() {
        this.dataset = new XYSeriesCollection();
        JFreeChart chart = ComponentFactory.createXYBarChart(STLConstants.K1105_SC.getValue(), STLConstants.K1110_VLNT.getValue(), (IntervalXYDataset)this.dataset, null);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        final String scLabel = "<html>" + STLConstants.K1105_SC.getValue() + ": ";
        final String vlntLabel = "<br>" + STLConstants.K1110_VLNT.getValue() + ": ";
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setBarAlignmentFactor(0.0);
        renderer.setMargin(0.2);
        renderer.setSeriesToolTipGenerator(0, new XYToolTipGenerator(){

            public String generateToolTip(XYDataset dataset, int arg1, int arg2) {
                int scNum = (int)dataset.getXValue(arg1, arg2);
                int vlntCount = (int)dataset.getYValue(arg1, arg2);
                return scLabel + scNum + vlntLabel + vlntCount + "</html>";
            }
        });
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setPreferredSize(PREFERRED_CHART_SIZE);
        this.propsPanel.add((Component)this.chartPanel);
    }
}

