/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.ConsolePromptType;
import com.intel.stl.ui.common.IHelp;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.console.IConsole;
import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.ScrollBuffer;
import com.wittams.gritty.Style;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.swing.TermPanel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class IntelTerminalPanel
extends TermPanel {
    private static final long serialVersionUID = 7434759697031493119L;
    protected KeyListener intelKeyHandler;
    protected boolean keyHandlerEnable = true;
    private final IHelp consoleHelpListener;
    private final IConsole consoleController;

    public IntelTerminalPanel(BackBuffer backBuffer, ScrollBuffer scrollBuffer, StyleState styleState, IHelp consoleHelpListener, IConsole consoleStateController) {
        super(backBuffer, scrollBuffer, styleState);
        this.consoleHelpListener = consoleHelpListener;
        this.consoleController = consoleStateController;
    }

    public void consumeRun(int x, int y, Style style, char[] buf, int start, int len) {
        super.consumeRun(x, y, style, buf, start, len);
        int old = start % this.getColumnCount();
        try {
            String cmd = null;
            if (this.consoleController.isInitialized()) {
                String command;
                int begin = start - old;
                int end = len + old;
                cmd = new String(buf, begin, end);
                String prompt = this.getPrompt(cmd);
                if (cmd != null && prompt != null && cmd.contains(prompt) && (command = Util.extractCommand(cmd, prompt)) != null && !command.isEmpty()) {
                    this.consoleHelpListener.parseCommand(command);
                    this.consoleHelpListener.updateSelection(command);
                    this.consoleController.setLastCommand(command);
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (this.keyHandlerEnable && this.intelKeyHandler != null) {
            int id = e.getID();
            if (id == 401) {
                this.intelKeyHandler.keyPressed(e);
            } else if (id != 402 && id == 400) {
                this.intelKeyHandler.keyTyped(e);
            }
            e.consume();
        }
    }

    public void setKeyHandler(KeyListener keyHandler) {
        this.intelKeyHandler = keyHandler;
    }

    public void enableKeyHandler(boolean enable) {
        this.keyHandlerEnable = enable;
    }

    private String getPrompt(String cmd) {
        if (cmd.contains(ConsolePromptType.ESM.getPrompt())) {
            return ConsolePromptType.ESM.getPrompt();
        }
        if (cmd.contains(ConsolePromptType.HSM_ROOT.getPrompt())) {
            return ConsolePromptType.HSM_ROOT.getPrompt();
        }
        if (cmd.contains(ConsolePromptType.HSM_USER.getPrompt())) {
            return ConsolePromptType.HSM_USER.getPrompt();
        }
        return null;
    }
}

