/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.console.view.IntelTerminalView;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TerminalCardView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = 4439143011519610809L;
    private JPanel mainPanel;
    private JLabel statusLabel;

    public TerminalCardView(String title) {
        super(title);
    }

    public void setTermPanel(IntelTerminalView panel) {
        panel.updateTermPanelDimensions(panel.getPreferredSize());
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)panel, "Center");
        this.mainPanel.revalidate();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.setOpaque(false);
        }
        return this.mainPanel;
    }

    @Override
    protected JComponent getExtraComponent() {
        if (this.statusLabel == null) {
            this.statusLabel = ComponentFactory.getH4Label(null, 1);
            this.statusLabel.setHorizontalAlignment(10);
            this.statusLabel.setForeground(UIConstants.INTEL_DARK_RED);
        }
        return this.statusLabel;
    }

    public void setLocked(boolean isSelected) {
        if (isSelected) {
            this.statusLabel.setText("[" + STLConstants.K1054_LOCKED.getValue() + "]");
        } else {
            this.statusLabel.setText("");
        }
    }

    public void displayMaxConsoles(boolean isMaxConsoles) {
        if (isMaxConsoles) {
            this.statusLabel.setText(UILabels.STL80004_MAX_CONSOLES.getDescription(50));
        } else {
            this.statusLabel.setText("");
        }
    }
}

