/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.event;

import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.monitor.TreeNodeType;
import java.util.ArrayList;
import java.util.List;

public class GroupsSelectedEvent
extends JumpToEvent {
    private final List<Item> items = new ArrayList<Item>();

    public GroupsSelectedEvent(Object origin, String destination) {
        super(origin, destination);
    }

    public GroupsSelectedEvent(Object origin, String destination, String name, TreeNodeType type) {
        super(origin, destination);
        this.addGroup(name, type);
    }

    public void addGroup(String name, TreeNodeType type) {
        Item item = new Item(name, type);
        this.items.add(item);
    }

    public String getName(int index) {
        return this.items.get(index).getName();
    }

    public TreeNodeType getType(int index) {
        return this.items.get(index).getType();
    }

    public int getNumGroups() {
        return this.items.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupsSelectedEvent other = (GroupsSelectedEvent)obj;
        return !(this.items == null ? other.items != null : !this.items.equals(other.items));
    }

    @Override
    public String toString() {
        return "GroupSelectedEvent [items=" + this.items + ", destination=" + this.destination + "]";
    }

    protected static class Item {
        private final String name;
        private final TreeNodeType type;

        public Item(String name, TreeNodeType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TreeNodeType getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "Item [name=" + this.name + ", type=" + (Object)((Object)this.type) + "]";
        }
    }
}

