/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.logger.config;

import com.intel.stl.api.configuration.AppenderConfig;
import com.intel.stl.api.configuration.LoggerConfig;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.api.configuration.RollingFileAppender;
import com.intel.stl.ui.logger.config.ILoggingControl;
import com.intel.stl.ui.logger.config.LoggingInputValidator;
import com.intel.stl.ui.logger.config.LoggingValidatorError;
import com.intel.stl.ui.logger.config.view.LoggingConfigView;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.main.view.FVMainFrame;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LoggingConfigController
implements ILoggingControl {
    private static LoggingConfigController instance;
    private final LoggingConfigView view;
    private List<AppenderConfig> appenders;
    private LoggingThreshold rootLogLevel;
    private HashMap<String, AppenderConfig> appenderConfigMap = null;
    private boolean done;
    private final ISubnetManager subnetMgr;
    private LoggingInputValidator validator;
    private boolean connectable;

    private LoggingConfigController(LoggingConfigView view, ISubnetManager subnetMgr) {
        this.view = view;
        this.view.setLoggingControlListener(this);
        this.subnetMgr = subnetMgr;
    }

    public static LoggingConfigController getInstance(FVMainFrame owner, ISubnetManager subnetMgr) {
        if (instance == null) {
            instance = new LoggingConfigController(new LoggingConfigView(owner), subnetMgr);
        }
        return instance;
    }

    protected void initAppenderList() {
        this.appenders = this.getLoggingConfig().getAppenders();
        if (this.appenders != null) {
            this.appenderConfigMap = new HashMap();
            for (int i = 0; i < this.appenders.size(); ++i) {
                AppenderConfig appenderConfig = this.appenders.get(i);
                this.appenderConfigMap.put(appenderConfig.getName(), appenderConfig);
            }
        }
    }

    protected void init() {
        this.validator = LoggingInputValidator.getInstance();
        this.rootLogLevel = this.getLoggingConfig().getRootLogger().getLevel();
        this.initAppenderList();
        this.view.initView(this.appenderConfigMap);
        this.view.setDirty(false);
        this.done = false;
    }

    protected void saveLoggingConfig(LoggingConfiguration loggingConfig) {
        this.subnetMgr.saveLoggingConfiguration(loggingConfig);
    }

    public LoggingConfiguration getLoggingConfig() {
        return this.subnetMgr.getLoggingConfig();
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean onOk() throws WizardValidationException {
        boolean success = false;
        LoggingConfiguration loggingConfig = new LoggingConfiguration();
        ArrayList<AppenderConfig> appenders = new ArrayList<AppenderConfig>(this.appenderConfigMap.values());
        loggingConfig.setAppenders(appenders);
        loggingConfig.setRootLogger(new LoggerConfig("Root", this.rootLogLevel));
        this.view.updateAppender(loggingConfig);
        int errorCode = this.validator.validate(loggingConfig);
        if (errorCode == LoggingValidatorError.OK.getId()) {
            this.saveLoggingConfig(loggingConfig);
            success = true;
        } else {
            this.view.showErrorMessage(LoggingValidatorError.getValue(errorCode));
        }
        return success;
    }

    @Override
    public void onReset() {
        this.initAppenderList();
        this.view.initView(this.appenderConfigMap);
        this.view.setDirty(false);
    }

    @Override
    public AppenderConfig getAppender(String name) {
        return this.appenderConfigMap.get(name);
    }

    public boolean isDirty() {
        return this.view.isDirty();
    }

    public void setDirty(boolean dirty) {
        this.view.setDirty(dirty);
    }

    @Override
    public String getAppenderName() {
        return null;
    }

    @Override
    public String getFileLocation(String appenderName) {
        AppenderConfig appenderConfig = this.appenderConfigMap.get(appenderName);
        RollingFileAppender appender = null;
        String location = null;
        if (appenderConfig != null) {
            appender = (RollingFileAppender)appenderConfig;
            location = appender.getFileLocation();
        }
        return location;
    }

    public void updateModel() {
    }

    public void clear() {
        this.view.clearPanel();
    }

    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    @Override
    public void showLoggingConfig() {
        this.init();
        this.view.showLoggingConfig();
    }

    @Override
    public LoggingThreshold getRootLoggingLevel() {
        return this.rootLogLevel;
    }

    @Override
    public void setRootLoggingLevel(LoggingThreshold level) {
        this.rootLogLevel = level;
    }
}

