/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.logger.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import com.intel.stl.api.configuration.AppenderConfig;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.api.configuration.RollingFileAppender;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Validator;
import com.intel.stl.ui.logger.config.LoggingValidatorError;
import com.intel.stl.ui.model.LoggingThresholdViz;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LoggingInputValidator {
    private final int OK = LoggingValidatorError.OK.getId();
    private final int MAX_BACKUP_FILES = 20;
    private final int kiloBytes = 1024;
    private final String byteStr = "B";
    private static LoggingInputValidator instance;
    ArrayList<String> validCodes = new ArrayList<String>(Arrays.asList(STLConstants.K0649_SC.getValue().trim(), STLConstants.K0650_C.getValue().trim(), STLConstants.K0651_D.getValue().trim(), STLConstants.K0652_F.getValue().trim(), STLConstants.K0653_SL.getValue().trim(), STLConstants.K0654_L.getValue().trim(), STLConstants.K0655_SM.getValue().trim(), STLConstants.K0656_M.getValue().trim(), STLConstants.K0657_SN.getValue().trim(), STLConstants.K0658_SP.getValue().trim(), STLConstants.K0659_SR.getValue().trim(), STLConstants.K0660_ST.getValue().trim(), STLConstants.K0661_SX.getValue().trim(), STLConstants.K0662_DOUBLE_PERCENT.getValue().trim()));

    public static LoggingInputValidator getInstance() {
        if (instance == null) {
            instance = new LoggingInputValidator();
        }
        return instance;
    }

    public int validate(LoggingConfiguration loggingConfig) {
        int errorCode = this.OK;
        LoggingThreshold rootLoggingLevel = loggingConfig.getRootLogger().getLevel();
        List<AppenderConfig> appenders = loggingConfig.getAppenders();
        boolean found = false;
        RollingFileAppender fileAppender = null;
        Iterator<AppenderConfig> it = appenders.iterator();
        while (it.hasNext() && !found) {
            AppenderConfig appender = it.next();
            if (!(appender instanceof RollingFileAppender)) continue;
            fileAppender = (RollingFileAppender)appender;
            found = true;
        }
        if (fileAppender != null) {
            errorCode = this.validateInformationLevel(fileAppender, rootLoggingLevel);
            if (errorCode == this.OK && (errorCode = this.validateOutputFormat(fileAppender)) == this.OK && (errorCode = this.validateMaxFileSize(fileAppender)) == this.OK && (errorCode = this.validateMaxNumFiles(fileAppender)) == this.OK) {
                errorCode = this.validateFileLocation(fileAppender);
            }
        } else {
            errorCode = LoggingValidatorError.UNSUPPORTED_APPENDER_TYPE.getId();
        }
        return errorCode;
    }

    protected int validateInformationLevel(RollingFileAppender fileAppender, LoggingThreshold threshold) {
        int errorCode = this.OK;
        String thresholdName = threshold.name().toLowerCase();
        String thresholdNameVizUpper = LoggingThresholdViz.getLoggingThresholdName(threshold);
        String thresholdNameViz = null;
        if (thresholdNameVizUpper != null) {
            thresholdNameViz = thresholdNameVizUpper.toLowerCase();
        }
        if (!thresholdName.equals(thresholdNameViz)) {
            errorCode = LoggingValidatorError.INVALID_THRESHOLD_TYPE.getId();
        }
        return errorCode;
    }

    protected int validateOutputFormat(RollingFileAppender fileAppender) {
        int errorCode = this.OK;
        String conversionPattern = fileAppender.getConversionPattern();
        if (conversionPattern == null || conversionPattern.equals("")) {
            errorCode = LoggingValidatorError.FORMAT_STRING_EMPTY.getId();
        } else {
            LoggerContext loggerContext = new LoggerContext();
            loggerContext.reset();
            PatternLayout encoder = new PatternLayout();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern(conversionPattern);
            encoder.start();
            List errors = loggerContext.getStatusManager().getCopyOfStatusList();
            if (errors.size() == 0) {
                errorCode = this.OK;
            } else {
                String emsg = ((Status)errors.get(errors.size() - 1)).getMessage();
                System.out.println(emsg);
                errorCode = LoggingValidatorError.FORMAT_STRING_INVALID.getId();
            }
        }
        return errorCode;
    }

    protected int validateMaxFileSize(RollingFileAppender fileAppender) {
        int errorCode = this.OK;
        String maxFileSizeStr = fileAppender.getMaxFileSize();
        if (Validator.isBlankOrNull(maxFileSizeStr)) {
            errorCode = LoggingValidatorError.MAX_FILE_SIZE_MISSING.getId();
        } else {
            String maxFileSizeNumOnly = null;
            String unit = null;
            if (!maxFileSizeStr.endsWith("B")) {
                maxFileSizeNumOnly = maxFileSizeStr;
            } else {
                unit = maxFileSizeStr.substring(maxFileSizeStr.length() - 2, maxFileSizeStr.length());
                maxFileSizeNumOnly = maxFileSizeStr.substring(0, maxFileSizeStr.length() - 2);
            }
            try {
                Long maxFileSize = new Long(maxFileSizeNumOnly);
                Long max = null;
                if (unit == null) {
                    max = Long.MAX_VALUE;
                } else if (unit.equals(STLConstants.K0695_KB.getValue())) {
                    max = 0x1FFFFFFFFFFFFFL;
                } else if (unit.equals(STLConstants.K0722_MB.getValue())) {
                    max = 0x7FFFFFFFFFFL;
                } else if (unit.equals(STLConstants.K0696_GB.getValue())) {
                    max = 0x1FFFFFFFFL;
                } else {
                    throw new IllegalArgumentException("Unknow unit '" + unit + "'");
                }
                if (maxFileSize <= 0L || max < maxFileSize) {
                    LoggingValidatorError.data = max;
                    errorCode = LoggingValidatorError.MAX_FILE_SIZE_OUT_OF_RANGE.getId();
                }
            }
            catch (NumberFormatException e) {
                errorCode = LoggingValidatorError.MAX_FILE_SIZE_FORMAT_EXCEPTION.getId();
            }
        }
        return errorCode;
    }

    protected int validateMaxNumFiles(RollingFileAppender fileAppender) {
        int errorCode = this.OK;
        String maxNumFilesStr = fileAppender.getMaxNumOfBackUp();
        try {
            if (Validator.isBlankOrNull(maxNumFilesStr)) {
                errorCode = LoggingValidatorError.MAX_NUM_FILES_MISSING.getId();
            } else {
                int maxNumFiles = Integer.parseInt(maxNumFilesStr);
                if (!(Integer.valueOf(maxNumFiles) instanceof Integer)) {
                    errorCode = LoggingValidatorError.MAX_NUM_FILES_INVALID_TYPE.getId();
                }
                if (maxNumFiles <= 0 || 20 < maxNumFiles) {
                    LoggingValidatorError.data = 20;
                    errorCode = LoggingValidatorError.MAX_NUM_FILES_OUT_OF_RANGE.getId();
                }
            }
        }
        catch (NumberFormatException e) {
            errorCode = LoggingValidatorError.MAX_NUM_FILES_FORMAT_EXCEPTION.getId();
        }
        return errorCode;
    }

    protected int validateFileLocation(RollingFileAppender fileAppender) {
        int errorCode = this.OK;
        File file = new File(fileAppender.getFileLocation());
        String fileLocationStr = fileAppender.getFileLocation();
        if (fileLocationStr == null || fileLocationStr.equals("")) {
            errorCode = LoggingValidatorError.FILE_LOCATION_MISSING.getId();
        } else if (file.isDirectory()) {
            errorCode = LoggingValidatorError.FILE_LOCATION_DIRECTORY_ERROR.getId();
        } else if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    errorCode = LoggingValidatorError.FILE_LOCATION_CREATION_ERROR.getId();
                }
            }
            catch (HeadlessException e) {
                errorCode = LoggingValidatorError.FILE_LOCATION_HEADLESS_ERROR.getId();
            }
            catch (IOException e) {
                errorCode = LoggingValidatorError.FILE_LOCATION_IO_ERROR.getId();
            }
        }
        return errorCode;
    }
}

