/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.FMKeyStoreException;
import com.intel.stl.api.FMTrustStoreException;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.SSLStoreCredentialsDeniedException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.DialogFactory;
import com.intel.stl.ui.main.view.CertsPanel;
import com.intel.stl.ui.wizards.view.MultinetWizardView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertsAssistant
implements ICertsAssistant {
    private static Logger log = LoggerFactory.getLogger(CertsAssistant.class);
    public static final int MAX_TRIES = 5;
    public static final long TIME_OUT = 30000L;
    private final IConfigurationApi confApi;
    private final ConcurrentHashMap<String, KeyManagerFactory> cachedKeyFactories = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TrustManagerFactory> cachedTrustFactories = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, List<String>> subnetKeyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, List<String>> subnetTrustMap = new ConcurrentHashMap();
    private final CertsPanel panel;

    public CertsAssistant(CertsPanel panel, IConfigurationApi confApi) {
        this.confApi = confApi;
        this.panel = panel;
    }

    @Override
    public SSLEngine getSSLEngine(SubnetDescription subnet) throws Exception {
        HostInfo hostInfo = subnet.getCurrentFE();
        String host = hostInfo.getHost();
        int port = hostInfo.getPort();
        KeyManagerFactory kmf = this.getKeyManagerFactory(subnet);
        TrustManagerFactory tmf = this.getTrustManagerFactory(subnet);
        SSLEngine engine = Utils.createSSLEngine(host, port, kmf, tmf);
        return engine;
    }

    @Override
    public SSLEngine getSSLEngine(HostInfo hostInfo) throws Exception {
        return null;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(SubnetDescription subnet) {
        CertsDescription certs = this.checkParameters(subnet);
        KeyManagerFactory factory = this.cachedKeyFactories.get(certs.getKeyStoreFile());
        if (factory == null) {
            factory = this.showPanelForKeyFactory(subnet, certs);
        }
        return factory;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(SubnetDescription subnet) {
        CertsDescription certs = this.checkParameters(subnet);
        TrustManagerFactory factory = this.cachedTrustFactories.get(certs.getTrustStoreFile());
        if (factory == null) {
            factory = this.showPanelForTrustFactory(subnet, certs);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubnetFactories(SubnetDescription subnet) {
        if (subnet != null) {
            List<String> list;
            List<String> trustNameList;
            List<String> list2;
            List<String> keyNameList = this.subnetKeyMap.remove(subnet.getSubnetId());
            if (keyNameList != null) {
                list2 = keyNameList;
                synchronized (list2) {
                    for (String name : keyNameList) {
                        this.cachedKeyFactories.remove(name);
                    }
                }
                keyNameList.clear();
            }
            if ((keyNameList = this.subnetKeyMap.remove(0L)) != null) {
                list2 = keyNameList;
                synchronized (list2) {
                    for (String name : keyNameList) {
                        this.cachedKeyFactories.remove(name);
                    }
                }
                keyNameList.clear();
            }
            if ((trustNameList = this.subnetTrustMap.remove(subnet.getSubnetId())) != null) {
                list = trustNameList;
                synchronized (list) {
                    for (String name : trustNameList) {
                        this.cachedTrustFactories.remove(name);
                    }
                }
                trustNameList.clear();
            }
            if ((trustNameList = this.subnetTrustMap.remove(0L)) != null) {
                list = trustNameList;
                synchronized (list) {
                    for (String name : trustNameList) {
                        this.cachedTrustFactories.remove(name);
                    }
                }
                trustNameList.clear();
            }
        }
    }

    private synchronized KeyManagerFactory showPanelForKeyFactory(SubnetDescription subnet, CertsDescription certs) {
        KeyManagerFactory factory = this.cachedKeyFactories.get(certs.getKeyStoreFile());
        if (factory == null) {
            this.showPanel(subnet, certs);
        }
        return this.cachedKeyFactories.get(certs.getKeyStoreFile());
    }

    private synchronized TrustManagerFactory showPanelForTrustFactory(SubnetDescription subnet, CertsDescription certs) {
        TrustManagerFactory factory = this.cachedTrustFactories.get(certs.getTrustStoreFile());
        if (factory == null) {
            this.showPanel(subnet, certs);
        }
        return this.cachedTrustFactories.get(certs.getTrustStoreFile());
    }

    private CertsDescription checkParameters(SubnetDescription subnet) {
        if (subnet == null) {
            IllegalArgumentException e = new IllegalArgumentException(UILabels.STL50200_SUBNETDESC_CANNOT_BE_NULL.getDescription());
            throw e;
        }
        CertsDescription certs = subnet.getCurrentFE().getCertsDescription();
        if (certs == null) {
            IllegalArgumentException e = new IllegalArgumentException(UILabels.STL50201_CERTSDESC_CANNOT_BE_NULL.getDescription(subnet.getName(), subnet.getCurrentFE().getHost()));
            throw e;
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPanel(SubnetDescription subnet, CertsDescription certs) {
        final CertsDescription currCerts = new CertsDescription(certs.getKeyStoreFile(), certs.getTrustStoreFile());
        HostInfo hostInfo = subnet.getCurrentFE();
        final String host = hostInfo.getHost();
        final ArrayList<Exception> errors = new ArrayList<Exception>();
        final Exchanger<Object> xchgr = new Exchanger<Object>();
        for (int tries = 5; tries > 0; --tries) {
            CertsDescription newCerts;
            if (!errors.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CertsDescription certs = CertsAssistant.this.getNewCerts(host, currCerts, errors, null);
                            xchgr.exchange(certs, 30000L, TimeUnit.MILLISECONDS);
                        }
                        catch (SSLStoreCredentialsDeniedException e1) {
                            errors.add(e1);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (TimeoutException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CertsDescription certs = CertsAssistant.this.getNewCerts(host, currCerts, null, null);
                            if (xchgr != null) {
                                xchgr.exchange(certs, 30000L, TimeUnit.MILLISECONDS);
                            }
                        }
                        catch (SSLStoreCredentialsDeniedException e1) {
                            errors.add(e1);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (TimeoutException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            try {
                newCerts = xchgr.exchange(null);
            }
            catch (InterruptedException e1) {
                return;
            }
            if (newCerts == null) {
                return;
            }
            errors.clear();
            KeyManagerFactory kmf = null;
            try {
                String keyFile = newCerts.getKeyStoreFile();
                kmf = Utils.createKeyManagerFactory(keyFile, newCerts.getKeyStorePwd());
                this.cachedKeyFactories.put(keyFile, kmf);
                List<String> subnetKeyList = this.subnetKeyMap.get(subnet.getSubnetId());
                if (subnetKeyList == null) {
                    List tempKeyList = Collections.synchronizedList(new ArrayList());
                    subnetKeyList = this.subnetKeyMap.putIfAbsent(subnet.getSubnetId(), tempKeyList);
                    if (subnetKeyList == null) {
                        subnetKeyList = tempKeyList;
                    }
                }
                subnetKeyList.add(keyFile);
            }
            catch (Exception e) {
                System.out.println("KeyManagerFactory error: " + e.getMessage());
                e.printStackTrace();
                errors.add(e);
            }
            finally {
                newCerts.clearKeyPwd();
            }
            TrustManagerFactory tmf = null;
            try {
                String trustFile = newCerts.getTrustStoreFile();
                tmf = Utils.createTrustManagerFactory(trustFile, newCerts.getTrustStorePwd());
                this.cachedTrustFactories.put(trustFile, tmf);
                List<String> subnetTrustList = this.subnetTrustMap.get(subnet.getSubnetId());
                if (subnetTrustList == null) {
                    List tempTrustList = Collections.synchronizedList(new ArrayList());
                    subnetTrustList = this.subnetTrustMap.putIfAbsent(subnet.getSubnetId(), tempTrustList);
                    if (subnetTrustList == null) {
                        subnetTrustList = tempTrustList;
                    }
                }
                subnetTrustList.add(trustFile);
            }
            catch (Exception e) {
                System.out.println("TrustManagerFactory error: " + e.getMessage());
                e.printStackTrace();
                errors.add(e);
            }
            finally {
                newCerts.clearTrustPwd();
            }
            if (!errors.isEmpty() || kmf == null || tmf == null) {
                continue;
            }
            this.commit(subnet);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertsDescription getNewCerts(String host, CertsDescription curCerts, List<Throwable> errors, Component subnetWindow) throws SSLStoreCredentialsDeniedException {
        if (errors == null || errors.isEmpty()) {
            this.panel.reset();
        }
        this.panel.setKeyStoreLocation(curCerts.getKeyStoreFile());
        this.panel.setTrustStoreLocation(curCerts.getTrustStoreFile());
        if (errors != null) {
            for (Throwable error : errors) {
                Throwable cause;
                if (error instanceof FMKeyStoreException) {
                    cause = this.getPasswordException(error);
                    if (cause != null) {
                        this.panel.setKeyStorePwdError(StringUtils.getErrorMessage(cause));
                        continue;
                    }
                    this.panel.setKeyStoreLocError(StringUtils.getErrorMessage(error.getCause()));
                    continue;
                }
                if (error instanceof FMTrustStoreException) {
                    cause = this.getPasswordException(error);
                    if (cause != null) {
                        this.panel.setTrustStorePwdError(StringUtils.getErrorMessage(cause));
                        continue;
                    }
                    this.panel.setTrustStoreLocError(StringUtils.getErrorMessage(error.getCause()));
                    continue;
                }
                log.warn("Unsupported error", error);
            }
        }
        Component multiNetWizardWindow = null;
        Window[] wins = Frame.getWindows();
        ArrayList toChange = new ArrayList();
        for (Window win : wins) {
            if (win instanceof MultinetWizardView) {
                multiNetWizardWindow = win;
            }
            if (!win.isAlwaysOnTop()) continue;
            win.setAlwaysOnTop(false);
        }
        try {
            int option;
            Component parentComponent = subnetWindow;
            if (multiNetWizardWindow != null && multiNetWizardWindow.isVisible()) {
                parentComponent = multiNetWizardWindow;
            }
            if ((option = DialogFactory.showPasswordDialog(parentComponent, STLConstants.K2000_CERT_CONF.getValue() + host, this.panel)) == DialogFactory.OK_OPTION) {
                CertsDescription newCerts = new CertsDescription(this.panel.getKeyStoreLocation(), this.panel.getTrustStoreLocation());
                newCerts.setKeyStorePwd(this.panel.getKeyStorePwd());
                newCerts.setTrustStorePwd(this.panel.getTrustStorePwd());
                CertsDescription certsDescription = newCerts;
                return certsDescription;
            }
            try {
                throw new SSLStoreCredentialsDeniedException(UILabels.STL10114_USER_CANCELLED);
            }
            catch (Exception e) {
                if (e instanceof SSLStoreCredentialsDeniedException && errors != null) {
                    errors.add(e);
                    throw e;
                }
                e.printStackTrace();
                for (Window win : toChange) {
                    win.setAlwaysOnTop(true);
                }
            }
        }
        finally {
            for (Window win : toChange) {
                win.setAlwaysOnTop(true);
            }
        }
        return null;
    }

    private Throwable getPasswordException(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof UnrecoverableKeyException && e.getMessage().contains("Password")) {
            return e;
        }
        return null;
    }

    private void commit(final SubnetDescription subnet) {
        this.panel.reset();
        if (subnet.getSubnetId() != 0L) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CertsAssistant.this.confApi.updateSubnet(subnet);
                    }
                    catch (SubnetDataNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }
}

