/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.framework.AbstractTask;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.FabricModel;
import com.intel.stl.ui.main.SubnetSwitchTask;
import java.util.List;

public class ContextSwitchTask
extends AbstractTask<FabricModel, Void, Void> {
    private final Context newContext;
    private final SubnetSwitchTask master;
    public final IContextAware contextPage;
    private IProgressObserver observer;
    private boolean hasException = false;
    private Throwable executionException;

    public ContextSwitchTask(FabricModel model, Context newContext, SubnetSwitchTask master, IContextAware contextPage) {
        super(model);
        this.newContext = newContext;
        this.master = master;
        this.contextPage = contextPage;
    }

    @Override
    public Void processInBackground(Context context) throws Exception {
        this.master.publishProgressNote(UILabels.STL10108_INIT_PAGE.getDescription(this.contextPage.getName()));
        short work = this.contextPage.getContextSwitchWeight().getWeight();
        this.observer = new ProgressObserver(this.master, work);
        this.contextPage.setContext(this.newContext, this.observer);
        return null;
    }

    @Override
    public void onTaskSuccess(Void result) {
        this.master.publishProgressNote(UILabels.STL10112_INIT_PAGE_COMPLETED.getDescription(this.contextPage.getName()));
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        this.hasException = true;
        this.executionException = caught;
    }

    @Override
    public void onFinally() {
        this.observer.onFinish();
        this.master.checkSubtasks();
    }

    @Override
    public void processIntermediateResults(List<Void> intermediateResults) {
    }

    public boolean hasException() {
        return this.hasException;
    }

    public Throwable getExecutionException() {
        return this.executionException;
    }
}

