/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.view.IChartRangeUpdater;
import com.intel.stl.ui.monitor.UnitDescription;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

public abstract class AbstractDataChartRangeUpdater
implements IChartRangeUpdater {
    protected String unitStr = "";
    protected String unitDes = "";
    protected double tickUnitSize = 1.0;
    protected static final long KB = 1000L;
    protected static final long MB = 1000000L;
    protected static final long GB = 1000000000L;

    @Override
    public void updateChartRange(JFreeChart chart, long lower, long upper) {
        if (lower > upper) {
            return;
        }
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis range = (NumberAxis)xyplot.getRangeAxis();
        range.setRangeWithMargins((double)lower, (double)upper);
        range.setLowerBound(0.0);
        TickUnitSource unitSrc = this.createTickUnits(upper);
        if (unitSrc != null) {
            range.setStandardTickUnits(unitSrc);
            xyplot.getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new DataToolTipGenerator("<html><b>{0}</b><br> Time: {1}<br> Data: {2}</html>", Util.getHHMMSS(), new DecimalFormat("#,##0.00 " + this.unitDes)));
        } else {
            range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        this.setChartRangeLabel(range);
    }

    @Override
    public void setChartRangeLabel(NumberAxis range) {
        range.setLabel(this.unitStr);
    }

    @Override
    public UnitDescription getUnitDescription() {
        return new UnitDescription(this.unitStr, this.tickUnitSize);
    }

    @Override
    public abstract TickUnitSource createTickUnits(long var1);

    class DataToolTipGenerator
    extends StandardXYToolTipGenerator {
        private static final long serialVersionUID = 4825888117284967486L;

        public DataToolTipGenerator(String string, DateFormat hhmmss, DecimalFormat decimalFormat) {
            super(string, hhmmss, (NumberFormat)decimalFormat);
        }

        protected Object[] createItemArray(XYDataset dataset, int series, int item) {
            DateFormat yDateFormat;
            DateFormat xDateFormat;
            String nullXString = "null";
            String nullYString = "null";
            Object[] result = new Object[3];
            result[0] = dataset.getSeriesKey(series).toString();
            double x = dataset.getXValue(series, item);
            result[1] = Double.isNaN(x) && dataset.getX(series, item) == null ? nullXString : ((xDateFormat = this.getXDateFormat()) != null ? xDateFormat.format(new Date((long)x)) : this.getXFormat().format(x));
            double y = dataset.getYValue(series, item);
            result[2] = Double.isNaN(y) && dataset.getY(series, item) == null ? nullYString : ((yDateFormat = this.getYDateFormat()) != null ? yDateFormat.format(new Date((long)y)) : this.getYFormat().format(y / AbstractDataChartRangeUpdater.this.tickUnitSize));
            return result;
        }
    }
}

