/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

class GradientPanel
extends JPanel {
    private final Color top;
    private final String title;
    private final Color bottom;

    GradientPanel(Color top, Color bottom, String title) {
        this.top = top;
        this.bottom = bottom;
        this.title = title;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.top, 0.0f, h, this.bottom);
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font titleFont = new Font("Dialog", 1, 20);
        g2d.setFont(titleFont);
        this.setForeground(Color.white);
        int x = 30;
        int y = titleFont.getSize() + (h - titleFont.getSize()) / 2;
        g2d.drawString(this.title, x, y);
    }
}

