/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class HealthHistoryView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = -7089992232091159132L;
    private final Font scoreFont;
    private JPanel mainPanel;
    private ChartPanel chartPanel;
    private JLabel startTimeLabel;
    private JLabel endTimeLabel;
    private TextTitle currentValue;
    private String scoreString = STLConstants.K0039_NOT_AVAILABLE.getValue();
    private Color scoreColor = UIConstants.INTEL_DARK_GRAY;
    private String scoreTip;

    public HealthHistoryView() {
        this(UIConstants.H1_FONT.deriveFont(1));
    }

    public HealthHistoryView(Font scoreFont) {
        super(STLConstants.K0105_HEALTH_HISTORY.getValue());
        this.getMainComponent();
        this.scoreFont = scoreFont;
    }

    @Override
    protected JPanel getMainComponent() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.mainPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        this.mainPanel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 0;
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HealthHistoryView.this.chartPanel.setMaximumDrawHeight(e.getComponent().getHeight());
                HealthHistoryView.this.chartPanel.setMaximumDrawWidth(e.getComponent().getWidth());
                HealthHistoryView.this.chartPanel.setMinimumDrawWidth(e.getComponent().getWidth());
                HealthHistoryView.this.chartPanel.setMinimumDrawHeight(e.getComponent().getHeight());
            }
        });
        this.mainPanel.add((Component)this.chartPanel, gc);
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.fill = 0;
        gc.anchor = 17;
        gc.weighty = 0.0;
        this.startTimeLabel = ComponentFactory.getH5Label("start", 0);
        this.mainPanel.add((Component)this.startTimeLabel, gc);
        gc.gridwidth = 0;
        gc.anchor = 13;
        this.endTimeLabel = ComponentFactory.getH5Label("end", 0);
        this.mainPanel.add((Component)this.endTimeLabel, gc);
        this.setHelpButtonName(WidgetName.HP_HEALTH_HIST_HELP.name());
        this.setPinButtonName(WidgetName.HP_HEALTH_HIST_PIN.name());
        return this.mainPanel;
    }

    public void setDataset(IntervalXYDataset dataset) {
        JFreeChart chart = ComponentFactory.createStepAreaChart((XYDataset)dataset, new XYItemLabelGenerator(){

            public String generateLabel(XYDataset dataset, int series, int item) {
                Number val = dataset.getY(series, item);
                return UIConstants.INTEGER.format(val.intValue());
            }
        });
        chart.addProgressListener(new ChartProgressListener(){

            public void chartProgress(ChartProgressEvent event) {
                if (event.getType() == 1 && HealthHistoryView.this.currentValue != null) {
                    HealthHistoryView.this.currentValue.setText(HealthHistoryView.this.scoreString);
                    HealthHistoryView.this.currentValue.setPaint((Paint)HealthHistoryView.this.scoreColor);
                    HealthHistoryView.this.currentValue.setToolTipText(HealthHistoryView.this.scoreTip);
                }
            }
        });
        XYPlot plot = chart.getXYPlot();
        plot.getRangeAxis().setRange(0.0, 105.0);
        plot.getRenderer().setSeriesPaint(0, (Paint)UIConstants.INTEL_BLUE);
        this.currentValue = new TextTitle(this.scoreString, this.scoreFont);
        this.currentValue.setPaint((Paint)this.scoreColor);
        this.currentValue.setToolTipText(this.scoreTip);
        this.currentValue.setPosition(RectangleEdge.BOTTOM);
        XYTitleAnnotation xytitleannotation = new XYTitleAnnotation(0.5, 0.5, (Title)this.currentValue, RectangleAnchor.CENTER);
        plot.addAnnotation((XYAnnotation)xytitleannotation);
        this.chartPanel.setChart(chart);
    }

    public void setTimeDuration(String start, String end) {
        this.startTimeLabel.setText(start);
        this.endTimeLabel.setText(end);
        this.validate();
    }

    public void setCurrentScore(String score, Color color, String tip) {
        this.scoreString = score;
        this.scoreColor = color;
        this.scoreTip = tip;
    }
}

