/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.JHorizontalBar;
import com.intel.stl.ui.main.view.AbstractNodeStatesView;
import com.intel.stl.ui.model.StateLongTypeViz;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class NodeStatesBar
extends AbstractNodeStatesView {
    private static final long serialVersionUID = 1036776904191810974L;
    private final boolean concise;
    private JHorizontalBar[] stateBars;
    private JLabel[] stateLabels;

    public NodeStatesBar(boolean concise) {
        this.concise = concise;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        StateLongTypeViz[] states = StateLongTypeViz.values();
        this.stateBars = new JHorizontalBar[states.length];
        this.stateLabels = new JLabel[states.length];
        for (int i = 0; i < states.length; ++i) {
            StateLongTypeViz state = states[i];
            gc.insets = new Insets(2, 5, 2, 2);
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            JLabel label = new JLabel(state.getName(), 4);
            label.setFont(UIConstants.H5_FONT);
            label.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.add((Component)label, gc);
            gc.insets = new Insets(2, 2, 2, 5);
            gc.weightx = 1.0;
            this.stateBars[i] = new JHorizontalBar();
            this.stateBars[i].setName(WidgetName.HP_STU_DIST_BAR_.name() + i);
            this.stateBars[i].setOpaque(false);
            this.stateBars[i].setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
            this.stateBars[i].setForeground(state.getColor());
            this.stateBars[i].setPreferredSize(new Dimension(60, 20));
            this.add((Component)this.stateBars[i], gc);
            if (this.concise) {
                gc.gridwidth = 0;
            }
            this.stateLabels[i] = new JLabel();
            this.stateLabels[i].setName(WidgetName.HP_STU_DIST_LABEL_.name() + i);
            this.stateLabels[i].setForeground(UIConstants.INTEL_DARK_GRAY);
            this.stateLabels[i].setFont(UIConstants.H3_FONT);
            this.add((Component)this.stateLabels[i], gc);
            if (this.concise) continue;
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            label = new JLabel(STLConstants.K0014_ACTIVE_NODES.getValue(), 4);
            label.setFont(UIConstants.H5_FONT);
            label.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.add((Component)label, gc);
        }
    }

    @Override
    public void setStates(double[] values, String[] labels, String[] tooltips) {
        if (values.length != this.stateBars.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateBars.length + " values, got " + values.length + " values.");
        }
        if (labels.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " labels, got " + labels.length + " labels.");
        }
        if (tooltips.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " tooltips, got " + tooltips.length + " tooltips.");
        }
        for (int i = 0; i < this.stateBars.length; ++i) {
            this.stateBars[i].setNormalizedValue(values[i]);
            this.stateBars[i].setToolTipText(tooltips[i]);
            this.stateLabels[i].setText(labels[i]);
            this.stateLabels[i].setToolTipText(tooltips[i]);
        }
    }

    public void clear() {
        for (int i = 0; i < this.stateLabels.length; ++i) {
            this.stateLabels[i].setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
            this.stateLabels[i].setToolTipText(null);
        }
    }
}

