/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.main.view.IWorstNodesListener;
import com.intel.stl.ui.main.view.WorstNodePopup;
import com.intel.stl.ui.model.NodeScore;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class WorstNodesView
extends JCardView<IWorstNodesListener>
implements ActionListener {
    private static final long serialVersionUID = 3495065577765787438L;
    private static int clickInterval = 200;
    private static final String NODE_SCORE = "NodeScore";
    public static final int NUM_NODES = 10;
    private JPanel mainPanel;
    private JPanel nodesPanel;
    private final WorstNodePopup popupComp;
    private final PopupFactory factory;
    private Popup popup;
    private int size;
    private int rows;
    private int columns;
    private MouseEvent mouseEvent;
    private final Timer timer;

    public WorstNodesView() {
        super(STLConstants.K0106_WORST_NODES.getValue());
        try {
            clickInterval = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        }
        catch (Exception e) {
            System.err.println("awt.multiClickInterval is not available on " + System.getProperty("os.name"));
        }
        this.getMainComponent();
        this.factory = PopupFactory.getSharedInstance();
        this.popupComp = new WorstNodePopup();
        this.timer = new Timer(clickInterval, this);
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.mainPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        this.mainPanel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridwidth = 0;
        gc.insets = new Insets(0, 5, 0, 1);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        JPanel panel = this.getNodesPanel();
        this.mainPanel.add((Component)panel, gc);
        this.setHelpButtonName(WidgetName.HP_WORST_NODES_HELP.name());
        this.setPinButtonName(WidgetName.HP_WORST_NODES_PIN.name());
        JScrollPane pane = new JScrollPane(this.mainPanel);
        pane.getViewport().getView().setBackground(this.getBackground());
        pane.setBorder(BorderFactory.createEmptyBorder(2, 0, 5, 0));
        pane.setPreferredSize(new Dimension(10, 10));
        return pane;
    }

    @Override
    public void setCardListener(IWorstNodesListener listener) {
        super.setCardListener(listener);
        this.popupComp.setListener(listener);
    }

    protected JPanel getNodesPanel() {
        if (this.nodesPanel == null) {
            this.nodesPanel = new JPanel(new GridBagLayout());
            this.nodesPanel.setOpaque(false);
            this.nodesPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
            this.setSize(10);
        }
        return this.nodesPanel;
    }

    public void setSize(int size) {
        this.size = size;
        int ratio = 5;
        this.rows = (int)Math.ceil(Math.sqrt(size / ratio));
        this.columns = ratio * this.rows;
    }

    public void updateNodes2(NodeScore[] nodes) {
        this.nodesPanel.removeAll();
        for (NodeScore node : nodes) {
            JLabel label = ComponentFactory.getH6Label(node.getScoreString(), 1);
            label.setHorizontalAlignment(0);
            label.setForeground(node.getColor());
            label.setToolTipText(node.getDescription());
            this.nodesPanel.add(label);
        }
        for (int i = 0; i < nodes.length; ++i) {
            NodeScore node = nodes[i];
            JLabel label = new JLabel(node.getIcon());
            label.setToolTipText(node.getDescription());
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    WorstNodesView.this.mouseEvent = e;
                    if (WorstNodesView.this.timer.isRunning() && !e.isConsumed() && e.getClickCount() > 1) {
                        WorstNodesView.this.timer.stop();
                        NodeScore node = (NodeScore)((JLabel)e.getComponent()).getClientProperty(WorstNodesView.NODE_SCORE);
                        ((IWorstNodesListener)WorstNodesView.this.listener).jumpTo(node.getLid(), node.getType(), JumpDestination.DEFAULT);
                    } else {
                        WorstNodesView.this.timer.restart();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            this.nodesPanel.add(label);
        }
        this.validate();
        this.repaint();
    }

    public void updateNodes(NodeScore[] nodes) {
        this.nodesPanel.removeAll();
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 0;
        gc.anchor = 10;
        gc.insets = new Insets(2, 0, 2, 0);
        for (int i = 0; i < nodes.length; ++i) {
            NodeScore node = nodes[i];
            JLabel label = new JLabel(node.getIcon());
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY), BorderFactory.createMatteBorder(0, 0, 5, 0, nodes[i].getColor())));
            label.setToolTipText(nodes[i].getDescription());
            label.putClientProperty(NODE_SCORE, node);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    WorstNodesView.this.mouseEvent = e;
                    if (WorstNodesView.this.timer.isRunning() && !e.isConsumed() && e.getClickCount() > 1) {
                        WorstNodesView.this.timer.stop();
                        NodeScore node = (NodeScore)((JLabel)e.getComponent()).getClientProperty(WorstNodesView.NODE_SCORE);
                        ((IWorstNodesListener)WorstNodesView.this.listener).jumpTo(node.getLid(), node.getType(), JumpDestination.DEFAULT);
                    } else {
                        WorstNodesView.this.timer.restart();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            gc.gridwidth = (i + 1) % this.columns == 0 ? 0 : 1;
            this.nodesPanel.add((Component)label, gc);
        }
        this.nodesPanel.validate();
        this.nodesPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        JLabel label = (JLabel)this.mouseEvent.getComponent();
        if (label.getParent() == null) {
            return;
        }
        NodeScore node = (NodeScore)label.getClientProperty(NODE_SCORE);
        this.popupComp.setNode(node);
        Point p = this.getPopupLocation(this.mouseEvent, this.popupComp);
        this.popup = this.factory.getPopup(this.mouseEvent.getComponent(), this.popupComp, p.x, p.y);
        this.popupComp.setPopup(this.popup);
        this.popup.show();
    }

    protected Point getPopupLocation(MouseEvent e, Component comp) {
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        p.x = Math.max(0, p.x - 5);
        p.y = Math.max(0, p.y - 5);
        Dimension d = comp.getPreferredSize();
        Rectangle rec = new Rectangle(p.x, p.y, d.width, d.height);
        p = Util.adjustPoint(rec, SwingUtilities.getWindowAncestor(this));
        return p;
    }

    public void clear() {
        this.nodesPanel.removeAll();
    }
}

