/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PropertyCategory;
import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.api.configuration.ResourceType;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.PropertySet;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class DeviceProperties
extends PropertySet<DevicePropertyGroup> {
    private final EnumMap<DeviceProperty, DevicePropertyItem> propertyMap = new EnumMap(DeviceProperty.class);
    private final EnumMap<ResourceCategory, DevicePropertyCategory> categoryMap = new EnumMap(ResourceCategory.class);
    private ResourceType resourceType;

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType deviceType) {
        this.resourceType = deviceType;
        this.clear();
    }

    public DevicePropertyItem getProperty(DeviceProperty property) {
        return this.propertyMap.get(property);
    }

    public List<DevicePropertyCategory> getCategories() {
        ArrayList<DevicePropertyCategory> categoryList = new ArrayList<DevicePropertyCategory>(this.categoryMap.size());
        categoryList.addAll(this.categoryMap.values());
        return categoryList;
    }

    public void addCategory(PropertyCategory category) {
        if (this.resourceType == null) {
            throw new RuntimeException(UILabels.STL90001_DEVICE_TYPE_NOT_SET.getDescription());
        }
        ResourceCategory resourceCategory = category.getResourceCategory();
        if (!resourceCategory.isApplicableTo(this.resourceType)) {
            throw new RuntimeException(UILabels.STL90002_DEVICE_CATEGORY_NOT_APPLICABLE.getDescription(resourceCategory.name(), this.resourceType.name()));
        }
        DevicePropertyCategory existing = this.categoryMap.get(category);
        if (existing != null) {
            return;
        }
        PropertyPageCategoryProxy newCategory = new PropertyPageCategoryProxy(category);
        this.categoryMap.put(resourceCategory, newCategory);
    }

    public DevicePropertyCategory getCategory(ResourceCategory category) {
        return this.categoryMap.get((Object)category);
    }

    @Override
    public void addPropertyGroup(DevicePropertyGroup propertyGroup) {
        for (ResourceCategory category : propertyGroup.getCategories()) {
            DevicePropertyCategory propertyCategory = this.categoryMap.get((Object)category);
            if (propertyCategory == null) {
                throw new RuntimeException(UILabels.STL90003_DEVICE_CATEGORY_NOT_SELECTED.getDescription(category.name(), this.resourceType.name()));
            }
            propertyGroup.addPropertyCategory(propertyCategory);
        }
        super.addPropertyGroup(propertyGroup);
    }

    @Override
    public void clear() {
        super.clear();
        this.propertyMap.clear();
        this.categoryMap.clear();
    }

    private class PropertyPageCategoryProxy
    extends DevicePropertyCategory {
        public PropertyPageCategoryProxy(PropertyCategory category) {
            super(category);
        }

        @Override
        public void addPropertyItem(DevicePropertyItem item) {
            DeviceProperties.this.propertyMap.put((Enum)item.getKey(), item);
            super.addPropertyItem(item);
        }
    }
}

