/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.FocusFlag;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public enum FocusFlagViz {
    OK(FocusFlag.OK, STLConstants.K0645_OK.getValue(), UIConstants.INTEL_DARK_GRAY),
    PMA_IGNORE(FocusFlag.PMA_IGNORE, STLConstants.K0212_PMA_IGNORE.getValue(), UIConstants.INTEL_BLUE),
    PMA_NORESP(FocusFlag.PMA_NORESP, STLConstants.K0213_PMA_NORESP.getValue(), UIConstants.INTEL_DARK_YELLOW),
    TOPO_NORESP(FocusFlag.TOPO_NORESP, STLConstants.K0214_TOPO_NORESP.getValue(), UIConstants.INTEL_DARK_RED);

    private static final Map<Byte, FocusFlagViz> focusFlagMap;
    private final FocusFlag flag;
    private final String value;
    private final Color color;

    private FocusFlagViz(FocusFlag flag, String value, Color color) {
        this.flag = flag;
        this.value = value;
        this.color = color;
    }

    public FocusFlag getFlag() {
        return this.flag;
    }

    public String getValue() {
        return this.value;
    }

    public Color getColor() {
        return this.color;
    }

    public static FocusFlagViz getFocusFlagViz(byte flag) {
        FocusFlagViz res = focusFlagMap.get(flag);
        if (res == null) {
            throw new IllegalArgumentException("Unknow flag '" + flag + "'!");
        }
        return res;
    }

    static {
        focusFlagMap = new HashMap<Byte, FocusFlagViz>();
        for (FocusFlagViz ffv : FocusFlagViz.values()) {
            focusFlagMap.put(ffv.flag.getCode(), ffv);
        }
    }
}

