/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.model.GraphCell;
import java.util.Map;
import java.util.TreeMap;

public class GraphEdge
extends GraphCell {
    private static final long serialVersionUID = 6368674272408088705L;
    private int fromLid;
    private byte fromType;
    private int toLid;
    private byte toType;
    private Map<Integer, Integer> links;

    public GraphEdge() {
    }

    public GraphEdge(int fromLid, byte fromType, int toLid, byte toType, Map<Integer, Integer> links) {
        this.fromLid = fromLid;
        this.fromType = fromType;
        this.toLid = toLid;
        this.toType = toType;
        this.links = links;
        this.name = this.createName();
    }

    public GraphEdge(String name, int fromLid, byte fromType, int toLid, byte toType, Map<Integer, Integer> links) {
        super(name);
        this.fromLid = fromLid;
        this.fromType = fromType;
        this.toLid = toLid;
        this.toType = toType;
        this.links = links;
    }

    public GraphEdge normalize() {
        if (this.fromLid < this.toLid) {
            TreeMap<Integer, Integer> reversedLinks = new TreeMap<Integer, Integer>();
            for (Integer key : this.links.keySet()) {
                reversedLinks.put(this.links.get(key), key);
            }
            return new GraphEdge(this.toLid, this.toType, this.fromLid, this.fromType, reversedLinks);
        }
        return this;
    }

    @Override
    public boolean isVertex() {
        return false;
    }

    protected String createName() {
        return this.fromLid + "-" + this.toLid;
    }

    public int getFromLid() {
        return this.fromLid;
    }

    public void setFromLid(int fromLid) {
        this.fromLid = fromLid;
    }

    public byte getFromType() {
        return this.fromType;
    }

    public void setFromType(byte fromType) {
        this.fromType = fromType;
    }

    public int getToLid() {
        return this.toLid;
    }

    public void setToLid(int toLid) {
        this.toLid = toLid;
    }

    public byte getToType() {
        return this.toType;
    }

    public void setToType(byte toType) {
        this.toType = toType;
    }

    public Map<Integer, Integer> getLinks() {
        return this.links;
    }

    public void setLinks(Map<Integer, Integer> links) {
        this.links = links;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromLid;
        result = 31 * result + this.fromType;
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + this.toLid;
        result = 31 * result + this.toType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphEdge other = (GraphEdge)obj;
        if (this.fromLid != other.fromLid) {
            return false;
        }
        if (this.fromType != other.fromType) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.toLid != other.toLid) {
            return false;
        }
        return this.toType == other.toType;
    }

    public String toString() {
        return this.fromLid + "-" + this.toLid + ":" + this.links.size() + " " + this.links;
    }
}

