/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDescription;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;

public class GroupStatistics {
    private final SubnetDescription subnet;
    private long numLinks;
    private EnumMap<NodeType, Integer> nodeTypesDist;
    private EnumMap<NodeType, Long> portTypesDist;
    private int numFailedNodes;
    private long numFailedPorts;
    private int numSkippedNodes;
    private long numSkippedPorts;
    private int numSMs;
    private List<SMInfoDataBean> smInfo;
    private long msmUptimeInSeconds;

    public GroupStatistics(SubnetDescription subnet, ImageInfoBean imageInfo, List<SMInfoDataBean> sms) {
        this.subnet = subnet;
        if (imageInfo == null) {
            throw new IllegalArgumentException("No imageInfo");
        }
        this.setImageInfo(imageInfo, sms);
    }

    public void setImageInfo(ImageInfoBean imageInfo, List<SMInfoDataBean> sms) {
        this.numLinks = imageInfo.getNumLinks();
        this.numFailedNodes = imageInfo.getNumFailedNodes();
        this.numFailedPorts = imageInfo.getNumFailedPorts();
        this.numSkippedNodes = imageInfo.getNumSkippedNodes();
        this.numSkippedPorts = imageInfo.getNumSkippedPorts();
        this.numSMs = imageInfo.getNumSMs();
        this.smInfo = new ArrayList<SMInfoDataBean>();
        SMInfoDataBean[] imgSmInfo = imageInfo.getSMInfo();
        HashSet<Integer> imgSMs = new HashSet<Integer>();
        for (int i = 0; i < imgSmInfo.length; ++i) {
            this.smInfo.add(imgSmInfo[i]);
            imgSMs.add(imgSmInfo[i].getLid());
        }
        if (sms != null) {
            for (SMInfoDataBean sm : sms) {
                if (imgSMs.contains(sm.getLid())) continue;
                this.smInfo.add(sm);
            }
        }
        this.nodeTypesDist = new EnumMap(NodeType.class);
        this.nodeTypesDist.put(NodeType.SWITCH, imageInfo.getNumSwitchNodes());
        this.nodeTypesDist.put(NodeType.HFI, imageInfo.getNumHFIPorts());
        this.portTypesDist = new EnumMap(NodeType.class);
        this.portTypesDist.put(NodeType.SWITCH, imageInfo.getNumSwitchPorts());
        this.portTypesDist.put(NodeType.HFI, Long.valueOf(imageInfo.getNumHFIPorts()));
    }

    public long getMsmUptimeInSeconds() {
        return this.msmUptimeInSeconds;
    }

    public void setMsmUptimeInSeconds(long msmUptimeInSeconds) {
        this.msmUptimeInSeconds = msmUptimeInSeconds;
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public int getNumNodes() {
        int sum = 0;
        if (this.nodeTypesDist != null) {
            for (Integer count : this.nodeTypesDist.values()) {
                sum += count.intValue();
            }
        }
        return sum;
    }

    public EnumMap<NodeType, Integer> getNodeTypesDist() {
        return this.nodeTypesDist;
    }

    public void setNodeTypesDist(EnumMap<NodeType, Integer> nodeTypesDist) {
        this.nodeTypesDist = nodeTypesDist;
    }

    public long getNumActivePorts() {
        long sum = 0L;
        if (this.portTypesDist != null) {
            for (NodeType type : this.portTypesDist.keySet()) {
                Long count = this.portTypesDist.get((Object)type);
                if (type == NodeType.OTHER || count == null) continue;
                sum += count.longValue();
            }
        }
        return sum;
    }

    public EnumMap<NodeType, Long> getPortTypesDist() {
        return this.portTypesDist;
    }

    public void setPortTypesDist(EnumMap<NodeType, Long> portTypesDist) {
        this.portTypesDist = portTypesDist;
    }

    public long getOtherPorts() {
        Long count = this.portTypesDist.get((Object)NodeType.OTHER);
        return count == null ? 0L : count;
    }

    public String getName() {
        return this.subnet.getName();
    }

    public int getNumFailedNodes() {
        return this.numFailedNodes;
    }

    public long getNumFailedPorts() {
        return this.numFailedPorts;
    }

    public int getNumSkippedNodes() {
        return this.numSkippedNodes;
    }

    public long getNumSkippedPorts() {
        return this.numSkippedPorts;
    }

    public int getNumSMs() {
        return this.numSMs;
    }

    public List<SMInfoDataBean> getSMInfo() {
        return this.smInfo;
    }

    public SMInfoDataBean getMasterSM() {
        if (this.smInfo != null && !this.smInfo.isEmpty()) {
            return this.smInfo.get(0);
        }
        return null;
    }

    public String toString() {
        return "GroupStatistics [name=" + this.subnet.getName() + ", numLinks=" + this.numLinks + ", nodeTypesDist=" + this.nodeTypesDist + ", portTypesDist=" + this.portTypesDist + ", numFailedNodes=" + this.numFailedNodes + ", numFailedPorts=" + this.numFailedPorts + ", numSkippedNodes=" + this.numSkippedNodes + ", numSkippedPorts=" + this.numSkippedPorts + ", numSMs=" + this.numSMs + ", SMInfo=" + this.smInfo + ", msmUptimeInSeconds=" + this.msmUptimeInSeconds + "]";
    }
}

