/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.ui.common.STLConstants;

public enum HistoryType {
    CURRENT(0, STLConstants.K1114_CURRENT.getValue()),
    ONE(1, Integer.toString(1) + STLConstants.K1112_HOURS.getValue()),
    TWO(2, Integer.toString(2) + STLConstants.K1112_HOURS.getValue()),
    SIX(6, Integer.toString(6) + STLConstants.K1112_HOURS.getValue()),
    DAY(24, Integer.toString(24) + STLConstants.K1112_HOURS.getValue());

    private final String name;
    private final int value;

    private HistoryType(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int getLengthInSeconds() {
        return this.value * 3600;
    }

    public int getMaxDataPoints(int refreshRate) {
        int maxDataPoints = this.getLengthInSeconds() / refreshRate;
        return maxDataPoints;
    }

    public String toString() {
        return this.name;
    }
}

