/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.LinkInitReason;
import com.intel.stl.ui.common.STLConstants;
import java.util.HashMap;
import java.util.Map;

public enum LinkInitReasonViz {
    NONE(LinkInitReason.NONE, STLConstants.K0383_NA.getValue()),
    LINKUP(LinkInitReason.LINKUP, STLConstants.K1781_LINK_INIT_LINKUP.getValue()),
    FLAPPING(LinkInitReason.FLAPPING, STLConstants.K1782_LINK_INIT_FLAPPING.getValue()),
    OUTSIDE_POLICY(LinkInitReason.OUTSIDE_POLICY, STLConstants.K1788_LINK_INIT_OUTSIDE_POLICY.getValue()),
    QUARANTINED(LinkInitReason.QUARANTINED, STLConstants.K1789_LINK_INIT_QUARANTINED.getValue()),
    INSUFIC_CAPABILITY(LinkInitReason.INSUFIC_CAPABILITY, STLConstants.K1790_LINK_INIT_INSUFIC_CAPABILITY.getValue());

    private static final Map<Byte, String> linkInitReasonMap;
    private final LinkInitReason reason;
    private final String value;

    private LinkInitReasonViz(LinkInitReason reason, String value) {
        this.reason = reason;
        this.value = value;
    }

    public LinkInitReason getReason() {
        return this.reason;
    }

    public String getValue() {
        return this.value;
    }

    public static String getLinkInitReasonStr(byte reason) {
        return linkInitReasonMap.get(reason);
    }

    static {
        linkInitReasonMap = new HashMap<Byte, String>();
        for (LinkInitReasonViz lirv : LinkInitReasonViz.values()) {
            linkInitReasonMap.put(lirv.reason.getCode(), lirv.value);
        }
    }
}

